/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.actor;

import com.caucho.amp.AmpQueryCallback;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.mailbox.AmpMailbox;
import com.caucho.amp.stream.AmpEncoder;
import com.caucho.amp.stream.AmpStream;

public abstract class AmpActorContext {
    private static final ThreadLocal<AmpActorContext> _currentContext = new ThreadLocal();

    public static final AmpActorContext getCurrent() {
        return _currentContext.get();
    }

    public static final AmpActorContext getCurrent(AmpActorContext systemContext) {
        AmpActorContext context = _currentContext.get();
        if (context != null) {
            return context;
        }
        return systemContext;
    }

    public abstract String getAddress();

    public abstract AmpMailbox getMailbox();

    public abstract AmpActorRef getActorRef();

    public abstract AmpStream getStream();

    public abstract AmpMethodRef getMethod(String var1, AmpEncoder var2);

    public final AmpActorContext beginCurrentActor() {
        AmpActorContext prev = _currentContext.get();
        _currentContext.set(this);
        return prev;
    }

    public final void endCurrentActor(AmpActorContext prev) {
        _currentContext.set(prev);
    }

    public abstract void query(AmpMethodRef var1, Object[] var2, AmpQueryCallback var3, long var4);

    public void send(AmpMethodRef methodRef, Object[] args) {
        methodRef.send(this.getActorRef(), args);
    }
}

