/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.marshal;

import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.MessageAnnotations;
import com.caucho.amqp.io.MessageAppProperties;
import com.caucho.amqp.io.MessageDeliveryAnnotations;
import com.caucho.amqp.io.MessageFooter;
import com.caucho.amqp.io.MessageProperties;
import com.caucho.amqp.marshal.AbstractMessageEncoder;
import com.caucho.amqp.marshal.AmqpEnvelope;
import com.caucho.amqp.marshal.AmqpMessageEncoder;
import com.caucho.message.MessagePropertiesFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class AmqpEnvelopeEncoder
extends AbstractMessageEncoder<AmqpEnvelope>
implements AmqpMessageEncoder<AmqpEnvelope> {
    public static final AmqpEnvelopeEncoder ENCODER = new AmqpEnvelopeEncoder();

    @Override
    protected void encodeDeliveryAnnotations(AmqpWriter out, MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) throws IOException {
        Iterator<Map.Entry<String, Object>> envIter = envelope.getDeliveryAnnotations();
        if (envIter.hasNext()) {
            MessageDeliveryAnnotations annotations = new MessageDeliveryAnnotations();
            annotations.putAll(envIter);
            annotations.write(out);
        }
    }

    @Override
    protected void encodeMessageAnnotations(AmqpWriter out, MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) throws IOException {
        Iterator<Map.Entry<String, Object>> envIter = envelope.getMessageAnnotations();
        if (envIter.hasNext()) {
            MessageAnnotations annotations = new MessageAnnotations();
            annotations.putAll(envIter);
            annotations.write(out);
        }
    }

    protected Object getMessageId(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        Object messageId = envelope.getMessageId();
        if (messageId == null) {
            messageId = factory.getMessageId();
        }
        return messageId;
    }

    protected String getUserId(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String userId = envelope.getUserId();
        if (userId == null) {
            userId = factory.getUserId();
        }
        return userId;
    }

    protected String getTo(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String to = envelope.getTo();
        if (to == null) {
            to = factory.getTo();
        }
        return to;
    }

    protected String getSubject(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String subject = envelope.getSubject();
        if (subject == null) {
            subject = factory.getSubject();
        }
        return subject;
    }

    protected String getReplyTo(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String replyTo = envelope.getReplyTo();
        if (replyTo == null) {
            replyTo = factory.getReplyTo();
        }
        return replyTo;
    }

    protected Object getCorrelationId(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        Object value = envelope.getCorrelationId();
        if (value == null) {
            value = factory.getCorrelationId();
        }
        return value;
    }

    protected String getContentType(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String value = envelope.getContentType();
        if (value == null) {
            value = factory.getContentType();
        }
        if (value == null) {
            value = "text/plain";
        }
        return value;
    }

    protected String getContentEncoding(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String value = envelope.getContentEncoding();
        if (value == null) {
            value = factory.getContentEncoding();
        }
        return value;
    }

    protected long getExpiryTime(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        long value = envelope.getExpiryTime();
        if (value <= 0L) {
            value = factory.getExpiryTime();
        }
        return value;
    }

    protected long getCreationTime(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        long value = envelope.getCreationTime();
        if (value <= 0L) {
            value = factory.getCreationTime();
        }
        return value;
    }

    protected String getGroupId(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String value = envelope.getGroupId();
        if (value == null) {
            value = factory.getGroupId();
        }
        return value;
    }

    protected long getGroupSequence(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        long value = envelope.getGroupSequence();
        if (value < 0L) {
            value = factory.getGroupSequence();
        }
        return value;
    }

    protected String getReplyToGroupId(MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) {
        String value = envelope.getReplyToGroupId();
        if (value == null) {
            value = factory.getReplyToGroupId();
        }
        return value;
    }

    @Override
    public String getContentType(AmqpEnvelope value) {
        return "text/plain";
    }

    @Override
    protected void encodeProperties(AmqpWriter out, MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) throws IOException {
        String replyToGroupId;
        long groupSequence;
        String groupId;
        long creationTime;
        long expiryTime;
        String contentEncoding;
        String contentType;
        Object correlationId;
        String replyTo;
        String subject;
        String to;
        String userId;
        MessageProperties properties = new MessageProperties();
        boolean isProperties = false;
        Object messageId = this.getMessageId(factory, envelope);
        if (messageId != null) {
            isProperties = true;
            properties.setMessageId(messageId);
        }
        if ((userId = this.getUserId(factory, envelope)) != null) {
            isProperties = true;
            properties.setUserId(userId);
        }
        if ((to = this.getTo(factory, envelope)) != null) {
            isProperties = true;
            properties.setTo(to);
        }
        if ((subject = this.getSubject(factory, envelope)) != null) {
            isProperties = true;
            properties.setSubject(subject);
        }
        if ((replyTo = this.getReplyTo(factory, envelope)) != null) {
            isProperties = true;
            properties.setReplyTo(replyTo);
        }
        if ((correlationId = this.getCorrelationId(factory, envelope)) != null) {
            isProperties = true;
            properties.setCorrelationId(correlationId);
        }
        if ((contentType = this.getContentType(factory, envelope)) != null) {
            isProperties = true;
            properties.setContentType(contentType);
        }
        if ((contentEncoding = this.getContentEncoding(factory, envelope)) != null) {
            isProperties = true;
            properties.setContentEncoding(contentEncoding);
        }
        if ((expiryTime = this.getExpiryTime(factory, envelope)) > 0L) {
            isProperties = true;
            properties.setExpiryTime(expiryTime);
        }
        if ((creationTime = this.getCreationTime(factory, envelope)) > 0L) {
            isProperties = true;
            properties.setCreationTime(creationTime);
        }
        if ((groupId = this.getGroupId(factory, envelope)) != null) {
            isProperties = true;
            properties.setGroupId(groupId);
        }
        if ((groupSequence = this.getGroupSequence(factory, envelope)) >= 0L) {
            isProperties = true;
            properties.setGroupSequence(groupSequence);
        }
        if ((replyToGroupId = this.getReplyToGroupId(factory, envelope)) != null) {
            isProperties = true;
            properties.setReplyToGroupId(replyToGroupId);
        }
        if (isProperties) {
            properties.write(out);
        }
    }

    @Override
    protected void encodeApplicationProperties(AmqpWriter out, MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) throws IOException {
        Iterator<Map.Entry<String, Object>> envIter = envelope.getProperties();
        if (envIter.hasNext()) {
            MessageAppProperties properties = new MessageAppProperties();
            properties.putAll(envIter);
            properties.write(out);
        }
    }

    @Override
    public void encodeData(AmqpWriter out, AmqpEnvelope envelope) throws IOException {
        out.writeDescriptor(119L);
        out.writeString(String.valueOf(envelope.getValue()));
    }

    @Override
    protected void encodeFooters(AmqpWriter out, MessagePropertiesFactory<AmqpEnvelope> factory, AmqpEnvelope envelope) throws IOException {
        Iterator<Map.Entry<String, Object>> envIter = envelope.getFooters();
        if (envIter.hasNext()) {
            MessageFooter footers = new MessageFooter();
            footers.putAll(envIter);
            footers.write(out);
        }
    }
}

