/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.server;

import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.amqp.io.AmqpError;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.message.SettleMode;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.ReceiverMessageHandler;
import java.io.IOException;
import java.io.InputStream;

public class AmqpServerSenderLink
extends AmqpSenderLink {
    private ReceiverMessageHandler _receiverHandler;
    private BrokerReceiver _receiver;
    private final SettleMode _settleMode;

    public AmqpServerSenderLink(String name, String address, SettleMode settleMode) {
        super(name, address);
        this._settleMode = settleMode;
        this._receiverHandler = new BrokerMessageReceiver();
    }

    ReceiverMessageHandler getBrokerHandler() {
        return this._receiverHandler;
    }

    void setReceiver(BrokerReceiver receiver) {
        this._receiver = receiver;
    }

    @Override
    public void onAccepted(long xid, long mid) {
        this._receiver.accepted(xid, mid);
    }

    @Override
    public void onReleased(long xid, long messageId) {
        this._receiver.released(xid, messageId);
    }

    @Override
    public void onRejected(long xid, long messageId, AmqpError error) {
        this._receiver.rejected(xid, messageId, error.getDescription());
    }

    @Override
    public void onModified(long xid, long mid, boolean isFailed, boolean isUndeliverableHere) {
        this._receiver.modified(xid, mid, isFailed, isUndeliverableHere);
    }

    @Override
    public void onFlow(FrameFlow flow) {
        super.onFlow(flow);
        this._receiver.flow(flow.getDeliveryCount(), flow.getLinkCredit());
    }

    private class BrokerMessageReceiver
    implements ReceiverMessageHandler {
        private BrokerMessageReceiver() {
        }

        @Override
        public void onMessage(long messageId, InputStream is, long contentLength) throws IOException {
            AmqpServerSenderLink.this.transfer(messageId, AmqpServerSenderLink.this._settleMode, is);
        }
    }
}

