/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.client;

import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.ActorHolder;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.SimpleActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.PassthroughBroker;
import com.caucho.bam.client.LinkConnectionFactory;
import com.caucho.bam.client.OutboundMessageStream;
import com.caucho.bam.mailbox.ActorMailbox;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.stream.MessageStream;

public class LinkClient {
    private LinkConnectionFactory _linkFactory;
    private ActorHolder _actor;
    private Broker _outboundBroker;
    private ActorSender _sender;

    public LinkClient(LinkConnectionFactory linkFactory, ActorHolder actor) {
        if (linkFactory == null) {
            throw new NullPointerException();
        }
        if (actor == null) {
            throw new NullPointerException();
        }
        this._linkFactory = linkFactory;
        this._actor = actor;
        PassthroughBroker inboundBroker = new PassthroughBroker();
        PassthroughBroker outboundBroker = new PassthroughBroker();
        Actor inboundStream = actor.getActor();
        SimpleActorSender sender = new SimpleActorSender(actor.getAddress(), inboundStream, outboundBroker);
        this._sender = sender;
        Mailbox inboundMailbox = this.createInboundMailbox(sender.getActor(), outboundBroker);
        inboundBroker.setMailbox(inboundMailbox);
        OutboundMessageStream outboundStream = new OutboundMessageStream(this._linkFactory, inboundBroker);
        Mailbox outboundMailbox = this.createOutboundMailbox(outboundStream, inboundBroker);
        outboundBroker.setMailbox(outboundMailbox);
        actor.setMailbox(inboundMailbox);
        actor.setBroker(outboundBroker);
        this._outboundBroker = outboundBroker;
    }

    public Broker getBroker() {
        return this._outboundBroker;
    }

    public ActorSender getSender() {
        return this._sender;
    }

    public void start() {
    }

    public void close() {
        Broker outboundBroker = this._outboundBroker;
        this._outboundBroker = null;
        if (outboundBroker != null) {
            outboundBroker.close();
        }
    }

    protected Mailbox createInboundMailbox(MessageStream inboundStream, Broker outboundBroker) {
        return new MultiworkerMailbox(inboundStream, outboundBroker, 1);
    }

    protected Mailbox createOutboundMailbox(MessageStream outboundStream, Broker inboundBroker) {
        return new ActorMailbox(outboundStream, inboundBroker);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._linkFactory + "," + this._actor + "]";
    }
}

