/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatusCommand
extends AbstractManagementCommand {
    private static Logger _log;
    private static L10N _L;

    @Override
    protected void initBootOptions() {
        this.addValueOption("server", "id", "select a configured server");
        this.addFlagOption("elastic-server", "use an elastic server in the cluster");
        this.addIntValueOption("watchdog-port", "port", "set watchdog port to listen to");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "watchdog and server status";
    }

    @Override
    public boolean isProOnly() {
        return false;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient clientWatchdog) throws BootArgumentException {
        try {
            String status = clientWatchdog.statusWatchdog();
            System.out.println(StatusCommand.L().l("Resin/{0} status for watchdog at {1}:{2}", (Object)VersionFactory.getVersion(), (Object)clientWatchdog.getWatchdogAddress(), (Object)clientWatchdog.getWatchdogPort()));
            System.out.println(status);
            try {
                super.doCommand(args, clientWatchdog, false);
            }
            catch (Exception e) {
                StatusCommand.log().log(Level.FINER, e.toString(), e);
            }
        }
        catch (Exception e) {
            System.out.println(StatusCommand.L().l("Resin/{0} can't retrieve status of -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)VersionFactory.getVersion(), (Object)clientWatchdog.getId(), (Object)clientWatchdog.getWatchdogAddress(), (Object)clientWatchdog.getWatchdogPort(), (Object)e.toString()));
            StatusCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient clientWatchdog, ManagerClient clientServer) throws BootArgumentException {
        try {
            try {
                String statusWebApp = clientServer.statusWebApp().getValue();
                if (statusWebApp != null) {
                    System.out.println(statusWebApp);
                }
            }
            catch (Exception e) {
                StatusCommand.log().log(Level.FINER, e.toString(), e);
            }
        }
        catch (Exception e) {
            StatusCommand.log().log(Level.FINE, e.toString(), e);
        }
        return 0;
    }

    @Override
    public boolean isRetry() {
        return true;
    }

    @Override
    public int retryCount() {
        return 2;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(StatusCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(StatusCommand.class);
        }
        return _L;
    }
}

