/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.server.deploy.DeployClient;
import com.caucho.util.L10N;

public class UndeployCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(UndeployCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("host", "host", "virtual host to make application available on");
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        this.addValueOption("m", "message", "commit message");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "undeploys an application";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String host;
        String name = args.getDefaultArg();
        if (name == null) {
            name = this.getName(args, null);
        }
        if (name == null || "/".equals(name)) {
            name = "ROOT";
        }
        if ((host = args.getArg("-host")) == null) {
            host = "default";
        }
        CommitBuilder commit = new CommitBuilder();
        commit.type("webapp");
        String stage = args.getArg("-stage");
        if (stage != null) {
            commit.stage(stage);
        }
        commit.tagKey(host + "/" + name);
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = "undeploy " + name + " from command line";
        }
        commit.message(message);
        commit.attribute("user", System.getProperty("user.name"));
        String version = args.getArg("-version");
        if (version != null) {
            DeployClient.fillInVersion(commit, version);
        }
        deployClient.removeTag(commit);
        System.out.println("Undeployed " + name + " from " + deployClient.getUrl());
        return 0;
    }

    @Override
    public String getUsageArgs() {
        return " [<name>]";
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

