/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootClusterConfig;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.Config;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.vfs.Path;

class WatchdogConfigHandle {
    private String _id = "default";
    private final int _index;
    private final BootClusterConfig _cluster;
    private final WatchdogArgs _args;
    private final Path _rootDirectory;
    private String _serverAddress = "127.0.0.1";
    private int _serverPort;
    private ContainerProgram _program = new ContainerProgram();
    private boolean _isAllowNonReservedIp;

    WatchdogConfigHandle(BootClusterConfig cluster, WatchdogArgs args, Path rootDirectory, int index) {
        this._cluster = cluster;
        this._args = args;
        this._rootDirectory = rootDirectory;
        this._index = index;
    }

    public void setId(String id) {
        if (id == null || "".equals(id)) {
            id = "default";
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public int getIndex() {
        return this._index;
    }

    public BootClusterConfig getCluster() {
        return this._cluster;
    }

    public String getHomeCluster() {
        if (this._cluster != null) {
            return this._cluster.getResin().getHomeCluster();
        }
        return null;
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    public void setAddress(String address) {
        this._serverAddress = address;
    }

    public String getAddress() {
        return this._serverAddress;
    }

    public void setPort(int port) {
        this._serverPort = port;
    }

    public int getPort() {
        return this._serverPort;
    }

    public boolean isAllowNonReservedIp() {
        return this._isAllowNonReservedIp;
    }

    public void addProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WatchdogConfig configure() {
        WatchdogConfig config = new WatchdogConfig(this._id, this._cluster, this._args, this._rootDirectory, this._index);
        String oldRvar0 = (String)Config.getProperty("rvar0");
        String oldRvar1 = (String)Config.getProperty("rvar1");
        try {
            Config.setProperty("rvar0", this._id);
            Config.setProperty("rvar1", this._cluster.getId());
            config.setAddress(this._serverAddress);
            config.setPort(this._serverPort);
            this._program.configure(config);
        }
        finally {
            Config.setProperty("rvar0", oldRvar0);
            Config.setProperty("rvar1", oldRvar1);
        }
        return config;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

