/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;

public class InterfaceMethodRefConstant
extends ConstantPoolEntry {
    private int _classIndex;
    private int _nameAndTypeIndex;

    InterfaceMethodRefConstant(ConstantPool pool, int index, int classIndex, int nameAndTypeIndex) {
        super(pool, index);
        this._classIndex = classIndex;
        this._nameAndTypeIndex = nameAndTypeIndex;
    }

    public String getClassName() {
        return this.getConstantPool().getClass(this._classIndex).getName();
    }

    public String getName() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getName();
    }

    public String getType() {
        return this.getConstantPool().getNameAndType(this._nameAndTypeIndex).getType();
    }

    public void setNameAndType(String name, String type) {
        this._nameAndTypeIndex = this.getConstantPool().addNameAndType(name, type).getIndex();
    }

    @Override
    void write(ByteCodeWriter out) throws IOException {
        out.write(11);
        out.writeShort(this._classIndex);
        out.writeShort(this._nameAndTypeIndex);
    }

    @Override
    public int export(ConstantPool target) {
        return target.addInterfaceRef(this.getClassName(), this.getName(), this.getType()).getIndex();
    }

    public String toString() {
        return "InterfaceMethodRefConstant[" + this.getClassName() + "." + this.getName() + "(" + this.getType() + ")]";
    }
}

