/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import java.io.IOException;

public class SignatureAttribute
extends Attribute {
    private String _signature;

    SignatureAttribute() {
        super("Signature");
    }

    SignatureAttribute(String signature) {
        super("Signature");
        this._signature = signature;
    }

    public String getSignature() {
        return this._signature;
    }

    public void read(ByteCodeParser in) throws IOException {
        int length = in.readInt();
        if (length != 2) {
            throw new IOException("expected length of 2 at " + length);
        }
        int code = in.readShort();
        this._signature = in.getUTF8(code);
    }

    @Override
    public void write(ByteCodeWriter out) throws IOException {
        out.writeUTF8Const(this.getName());
        out.writeInt(2);
        out.writeUTF8Const(this._signature);
    }

    @Override
    public Attribute export(JavaClass source, JavaClass target) {
        ConstantPool cp = target.getConstantPool();
        cp.addUTF8(this.getName());
        cp.addUTF8(this._signature);
        return new SignatureAttribute(this._signature);
    }

    @Override
    public String toString() {
        return "SignatureAttribute[" + this._signature + "]";
    }
}

