/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class IntegerPrimitiveType
extends ConfigType<Integer> {
    private static final L10N L = new L10N(IntegerPrimitiveType.class);
    public static final IntegerPrimitiveType TYPE = new IntegerPrimitiveType();
    private static final Integer ZERO = new Integer(0);

    private IntegerPrimitiveType() {
    }

    @Override
    public Class<Integer> getType() {
        return Integer.TYPE;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return ZERO;
        }
        return Integer.valueOf(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        if (value == null) {
            return ZERO;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Integer(((Number)value).intValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to an int", value));
    }
}

