/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.types.InjectionTarget;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class MessageDestinationRef
implements ObjectProxy {
    private final L10N L = new L10N(MessageDestinationRef.class);
    private final Logger log = Logger.getLogger(MessageDestinationRef.class.getName());
    private final Path _modulePath;
    private final Context _context;
    private String _refName;
    private Class _type;
    private String _link;
    private String _foreignName;
    private Object _target;
    private InjectionTarget _injectionTarget;

    public MessageDestinationRef() {
        this._modulePath = Vfs.lookup();
        this._context = null;
    }

    public MessageDestinationRef(Path modulePath) {
        this._modulePath = modulePath;
        this._context = null;
    }

    public MessageDestinationRef(Context context) {
        this._context = context;
        this._modulePath = Vfs.getPwd();
    }

    public void setDescription(String description) {
    }

    public void setInjectionTarget(InjectionTarget injectionTarget) {
        this._injectionTarget = injectionTarget;
    }

    public void setMessageDestinationRefName(String refName) {
        this._refName = refName;
    }

    public void setMessageDestinationRefType(Class<?> type) {
        this._type = type;
    }

    public void setMessageDestinationRefUsage(String usage) {
    }

    public void setMessageDestinationLink(String link) {
        this._link = link;
    }

    public void setForeignName(String foreignName) {
        this._foreignName = foreignName;
    }

    @PostConstruct
    public void init() throws NamingException {
        String fullForeignName;
        boolean bind = false;
        if (this._link != null || this._foreignName == null) {
            // empty if block
        }
        String fullRefName = Jndi.getFullName(this._refName);
        if (this._link != null) {
            bind = true;
        } else if (this._foreignName != null && !(fullForeignName = Jndi.getFullName(this._foreignName)).equals(fullRefName)) {
            bind = true;
        }
        if (bind) {
            Jndi.rebindDeep(fullRefName, this);
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, this.L.l("{0} init", (Object)this));
        }
    }

    public InjectionTarget getInjectionTarget() {
        return this._injectionTarget;
    }

    protected String getTagName() {
        return "<message-destination-ref>";
    }

    public Object createObject(Hashtable env) throws NamingException {
        if (this._target == null) {
            this.resolve(this._type);
        }
        return this._target;
    }

    private void resolve(Class type) throws NamingException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.L.l("{0} resolving", (Object)this));
        }
        this._target = this._foreignName != null ? this.lookupByForeignJndi(this._foreignName, type) : this.lookupByLink(this._link, type);
        if (this.log.isLoggable(Level.CONFIG) && this.log.isLoggable(Level.CONFIG)) {
            this.log.log(Level.CONFIG, this.L.l("{0} resolved", (Object)this));
        }
    }

    private Object lookupByLink(String link, Class type) throws NamingException {
        return null;
    }

    private Object lookupByForeignJndi(String foreignName, Class type) throws NamingException {
        Object target = this._context != null ? this._context.lookup(Jndi.getFullName(foreignName)) : Jndi.lookup(foreignName);
        if (target == null) {
            if (foreignName.equals(this._refName)) {
                throw new NamingException(this.L.l("{0} '{1}' cannot be resolved", (Object)this.getTagName(), (Object)this._refName));
            }
            throw new NamingException(this.L.l("{0} '{1}' foreign-name '{2}' not found", (Object)this.getTagName(), (Object)this._refName, (Object)foreignName));
        }
        if (type != null) {
            target = PortableRemoteObject.narrow((Object)target, (Class)type);
        }
        return target;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ref-name=" + this._refName + ", link=" + this._link + ", foreign-name=" + this._foreignName + "]";
    }
}

