/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.index;

import com.caucho.db.index.BTree;
import com.caucho.db.index.IndexCache;
import com.caucho.util.Hex;
import com.caucho.util.LruListener;

public final class IndexKey
implements LruListener {
    private BTree _btree;
    private byte[] _data;
    private int _offset;
    private int _length;
    private long _value;
    private boolean _isValid;
    private boolean _isStored;

    public IndexKey() {
    }

    public IndexKey(BTree btree, byte[] data, int offset, int length, long value) {
        this.init(btree, data, offset, length);
        this._value = value;
    }

    public static IndexKey create(BTree btree, byte[] data, int offset, int length, long value) {
        byte[] dataCopy = new byte[length];
        System.arraycopy(data, offset, dataCopy, 0, length);
        return new IndexKey(btree, dataCopy, 0, length, value);
    }

    public void init(BTree btree, byte[] data, int offset, int length) {
        this._btree = btree;
        this._data = data;
        this._offset = offset;
        this._length = length;
    }

    public BTree getBTree() {
        return this._btree;
    }

    public byte[] getBuffer() {
        return this._data;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLength() {
        return this._length;
    }

    public void setValue(long value) {
        this._value = value;
    }

    public long getValue() {
        return this._value;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void setValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isStored() {
        return this._isStored;
    }

    public void setStored(boolean isStored) {
        this._isStored = isStored;
    }

    @Override
    public void lruEvent() {
        IndexCache cache = IndexCache.create();
        cache.addWrite(this);
    }

    public void update() {
    }

    public int hashCode() {
        int hash = this._btree.hashCode();
        byte[] data = this._data;
        for (int length = this._length - 1; length >= 0; --length) {
            hash = 65521 * hash + data[length];
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexKey)) {
            return false;
        }
        IndexKey key = (IndexKey)o;
        if (this._btree != key._btree) {
            return false;
        }
        int length = this._length;
        if (length != key._length) {
            return false;
        }
        byte[] dataA = this._data;
        byte[] dataB = key._data;
        int offsetA = this._offset;
        int offsetB = key._offset;
        for (int i = 0; i < length; ++i) {
            if (dataA[offsetA + i] == dataB[offsetB + i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._btree + "," + Hex.toHex(this._data, 0, this._length) + "]";
    }
}

