/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.io;

import com.caucho.db.io.InStore;
import com.caucho.db.io.OutStore;
import com.caucho.db.io.StoreBuilder;
import com.caucho.db.io.StoreReadWrite;
import com.caucho.util.ConcurrentArrayList;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class StoreReadWriteMmapNio
implements StoreReadWrite {
    private static final L10N L = new L10N(StoreReadWriteMmapNio.class);
    private final Path _path;
    private long _fileSize;
    private FileChannel _channel;
    private long _mmapChunkSize;
    private final ConcurrentArrayList<MmapFile> _mmapFiles = new ConcurrentArrayList<MmapFile>(MmapFile.class);
    private MmapFile[] _mmapFileChunks = new MmapFile[0];
    private long _mmapCloseTimeout = 1000L;
    private final AtomicBoolean _isClosed = new AtomicBoolean();
    private FreeList<InStoreImpl> _freeInStore = new FreeList(16);
    private FreeList<OutStoreMmapNio> _freeOutStore = new FreeList(16);
    private AtomicLong _storeSequence = new AtomicLong();

    StoreReadWriteMmapNio(StoreBuilder builder) {
        this._path = builder.getPath();
        if (this._path == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public long getFileSize() {
        return this._fileSize;
    }

    private void setFileSize(long size) {
        this._fileSize = Math.max(this._fileSize, size);
    }

    @Override
    public long getChunkSize() {
        return 0x800000L;
    }

    @Override
    public long getMmapCloseTimeout() {
        return this._mmapCloseTimeout;
    }

    boolean isFileExist() {
        return this._path.exists();
    }

    @Override
    public void create() throws IOException {
        this._path.getParent().mkdirs();
        if (this._path.exists()) {
            throw new IOException(L.l("CREATE for path '{0}' failed, because the file already exists.  CREATE can not override an existing table.", (Object)this._path.getNativePath()));
        }
        this._channel = this._path.fileChannelFactory().openFileChannel(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        this.setFileSize(this._path.getLength());
        this.initImpl();
    }

    @Override
    public void init() throws IOException {
        if (this._channel == null) {
            this._channel = this._path.fileChannelFactory().openFileChannel(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }
        this.setFileSize(this._path.getLength());
        this.initImpl();
    }

    private void initImpl() throws IOException {
        long fileSize = this.getFileSize();
        long highBit = Long.highestOneBit(fileSize);
        int chunkSize = (int)Math.min(highBit >> 3, 0x10000000L);
        chunkSize = Math.max(chunkSize, 0x800000);
        this._mmapChunkSize = chunkSize;
        for (long offset = 0L; offset < fileSize; offset += (long)chunkSize) {
            this.streamOpen(offset, chunkSize);
        }
    }

    @Override
    public InStore openRead(long address, int size) {
        if (this.getFileSize() < address + (long)size) {
            throw new IllegalStateException(L.l("{0} read open for length {1}:{2} but file length {3}", (Object)this, (Object)address, (Object)size, (Object)this.getFileSize()));
        }
        if (this._isClosed.get()) {
            throw new IllegalStateException(L.l("{0} is closed.", (Object)this));
        }
        if (this._fileSize < address + (long)size) {
            throw new IllegalStateException(L.l("Open read of large file {0}:{1}", (Object)Long.toHexString(address), size));
        }
        try {
            this.streamOpen(address, size);
            return this.openReadImpl(address, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutStore openWrite(long address, int size) {
        if (this._isClosed.get()) {
            throw new IllegalStateException(L.l("{0} is closed.", (Object)this));
        }
        if (size <= 0) {
            throw new IllegalArgumentException(L.l("Invalid size: {0}", size));
        }
        if (address < 0L) {
            throw new IllegalArgumentException(L.l("Invalid address: {0}", (Object)Long.toHexString(address)));
        }
        try {
            this.streamOpen(address, size);
            return this.openWriteImpl(address, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InStore openReadImpl(long address, int size) {
        return new InStoreFacade(address, size);
    }

    private InStoreImpl allocateRead() {
        InStoreImpl inStore = this._freeInStore.allocate();
        if (inStore != null && inStore.getSequence() == this._storeSequence.get()) {
            return inStore;
        }
        return new InStoreImpl();
    }

    private OutStore openWriteImpl(long address, int size) {
        return new OutStoreFacade(address, size);
    }

    private OutStoreMmapNio allocateWrite() {
        OutStoreMmapNio outStore = this._freeOutStore.allocate();
        if (outStore != null && outStore.getSequence() == this._storeSequence.get()) {
            return outStore;
        }
        return new OutStoreMmapNio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MmapFile streamOpen(long address, int size) throws IOException {
        if (this._isClosed.get()) {
            throw new IllegalStateException();
        }
        int chunkIndex = (int)((address + (long)size - 1L) / this._mmapChunkSize);
        if (chunkIndex < 0) {
            throw new IllegalStateException(L.l("Invalid stream address: 0x{0} size: 0x{1} chunk: {2}", (Object)Long.toHexString(address), (Object)Long.toHexString(size), (Object)chunkIndex));
        }
        ConcurrentArrayList<MmapFile> concurrentArrayList = this._mmapFiles;
        synchronized (concurrentArrayList) {
            long delta;
            if (chunkIndex < this._mmapFileChunks.length) {
                MmapFile mmapFile = this._mmapFileChunks[chunkIndex];
                return mmapFile;
            }
            long reqSize = Math.max(address + (long)size, this._path.getLength());
            long fileSize = this.extendFileSize(this._fileSize, reqSize);
            this.setFileSize(fileSize);
            if (fileSize % this._mmapChunkSize != 0L) {
                throw new IllegalStateException(L.l("file size 0x{0} must be an increment of the chunk size 0x{1}", (Object)Long.toHexString(fileSize), (Object)Long.toHexString(this._mmapChunkSize)));
            }
            MmapFile mmapFile = null;
            for (long tailAddress = (long)this._mmapFileChunks.length * this._mmapChunkSize; tailAddress < fileSize; tailAddress += delta) {
                delta = Math.min(fileSize - tailAddress, 0x3FFFFFFFL);
                delta -= delta % this._mmapChunkSize;
                mmapFile = new MmapFile(this._channel, tailAddress, (int)delta);
                this.appendMmapFile(mmapFile);
            }
            this._storeSequence.incrementAndGet();
            if (mmapFile.getAddress() + mmapFile.getSize() < address + (long)size) {
                throw new IllegalStateException(L.l("Invalid mmap chunk. Requested <0x{0},0x{1}>. Received <0x{2},0x{3}>", (Object)Long.toHexString(address), (Object)Long.toHexString(size), (Object)Long.toHexString(mmapFile.getAddress()), (Object)Long.toHexString(mmapFile.getSize())));
            }
            return mmapFile;
        }
    }

    private void appendMmapFile(MmapFile mmapFile) {
        int i;
        this._mmapFiles.add(mmapFile);
        long tail = mmapFile.getAddress() + mmapFile.getSize();
        int index = (int)(mmapFile.getAddress() / this._mmapChunkSize);
        if (index != this._mmapFileChunks.length) {
            throw new IllegalStateException();
        }
        MmapFile[] newMmapChunks = new MmapFile[(int)(tail / this._mmapChunkSize)];
        System.arraycopy(this._mmapFileChunks, 0, newMmapChunks, 0, index);
        for (i = index; i < newMmapChunks.length; ++i) {
            newMmapChunks[i] = mmapFile;
        }
        this._mmapFileChunks = newMmapChunks;
        for (i = 1; i < newMmapChunks.length; ++i) {
            MmapFile ptr = newMmapChunks[i];
            MmapFile prev = newMmapChunks[i - 1];
            if (ptr == prev || prev.getAddress() + prev.getSize() == ptr.getAddress()) continue;
            throw new IllegalStateException();
        }
    }

    private long extendFileSize(long oldFileSize, long reqFileSize) {
        long mod;
        long newFileSize = reqFileSize <= oldFileSize ? oldFileSize : 5L * oldFileSize / 4L + 0x800000L;
        long index = Long.highestOneBit(newFileSize);
        long mask = (index - 1L ^ 0xFFFFFFFFFFFFFFFFL) >> 3;
        newFileSize = Math.max(newFileSize & mask, reqFileSize);
        long chunkSize = this._mmapChunkSize;
        if ((newFileSize -= (mod = newFileSize % chunkSize)) < reqFileSize) {
            newFileSize += chunkSize;
        }
        return newFileSize;
    }

    @Override
    public void fsync() {
        for (MmapFile mmapFile : this._mmapFiles) {
            mmapFile.fsyncImpl();
        }
    }

    @Override
    public void close() {
        if (this._isClosed.getAndSet(true)) {
            return;
        }
        this.fsync();
        FileChannel channel = this._channel;
        this._channel = null;
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }

    class OutStoreMmapNio
    implements OutStore {
        private final MmapFile[] _mmapFile;
        private final ByteBuffer[] _mmap;
        private final ArrayList<MmapFile> _mmapFileList = new ArrayList();
        private final long _sequence;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OutStoreMmapNio() {
            this._sequence = StoreReadWriteMmapNio.this._storeSequence.get();
            ConcurrentArrayList concurrentArrayList = StoreReadWriteMmapNio.this._mmapFiles;
            synchronized (concurrentArrayList) {
                this._mmapFile = StoreReadWriteMmapNio.this._mmapFileChunks;
                int indexEnd = (int)((StoreReadWriteMmapNio.this.getFileSize() - 1L) / StoreReadWriteMmapNio.this._mmapChunkSize);
                this._mmap = new ByteBuffer[indexEnd + 1];
                MappedByteBuffer lastBuffer = null;
                for (int i = 0; i < this._mmap.length; ++i) {
                    long address = (long)i * StoreReadWriteMmapNio.this._mmapChunkSize;
                    for (int j = 0; j < this._mmapFile.length; ++j) {
                        MmapFile mmapFile = this._mmapFile[j];
                        if (mmapFile.getAddress() > address || address >= mmapFile.getAddress() + mmapFile.getSize()) continue;
                        if (lastBuffer == mmapFile.getByteBuffer()) {
                            this._mmap[i] = this._mmap[i - 1];
                        } else {
                            this._mmapFileList.add(mmapFile);
                            this._mmap[i] = mmapFile.getByteBuffer().duplicate();
                        }
                        lastBuffer = mmapFile.getByteBuffer();
                        break;
                    }
                    if (this._mmap[i] != null) continue;
                    throw new IllegalStateException(L.l("Invalid initialization address=0x{0}", (Object)Long.toHexString(address)));
                }
            }
        }

        public long getSequence() {
            return this._sequence;
        }

        @Override
        public long getLength() {
            return StoreReadWriteMmapNio.this._fileSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(long address, byte[] buffer, int offset, int length) {
            while (length > 0) {
                ByteBuffer mmap;
                int mmapIndex = (int)(address / StoreReadWriteMmapNio.this._mmapChunkSize);
                ByteBuffer mmapBuf = mmap = this._mmap[mmapIndex];
                ByteBuffer byteBuffer = mmap;
                synchronized (byteBuffer) {
                    MmapFile mmapFile = this._mmapFile[mmapIndex];
                    int mmapOffset = (int)(address - mmapFile.getAddress());
                    int sublen = (int)Math.min((long)length, mmapFile.getSize() - (long)mmapOffset);
                    ((Buffer)mmapBuf).limit(mmapOffset + sublen);
                    ((Buffer)mmapBuf).position(mmapOffset);
                    mmap.put(buffer, offset, sublen);
                    mmapFile.setDirty();
                    length -= sublen;
                    offset += sublen;
                    address += (long)sublen;
                }
            }
            return true;
        }

        private MmapFile getLastMmap() {
            return this._mmapFile[this._mmap.length - 1];
        }

        @Override
        public OutStore clone() {
            throw new IllegalStateException();
        }

        @Override
        public void close() {
            throw new IllegalStateException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + StoreReadWriteMmapNio.this._path + "]";
        }
    }

    class OutStoreFacade
    implements OutStore {
        private OutStoreMmapNio _outStore;
        private long _address;
        private int _size;

        OutStoreFacade(long address, int size) {
            this._outStore = StoreReadWriteMmapNio.this.allocateWrite();
            this._address = address;
            this._size = size;
        }

        @Override
        public long getLength() {
            return StoreReadWriteMmapNio.this._fileSize;
        }

        @Override
        public boolean write(long address, byte[] buffer, int offset, int length) {
            if (address < this._address) {
                throw new IllegalStateException(L.l("Address 0x{0} less than {1} offset 0x{2}", (Object)Long.toHexString(address), (Object)OutStoreMmapNio.class.getSimpleName(), (Object)Long.toHexString(this._address)));
            }
            if (this._address + (long)this._size < address + (long)length) {
                throw new IllegalStateException(L.l("Tail 0x{0} greater than mmap tail 0x{1}", (Object)Long.toHexString(address + (long)length), (Object)Long.toHexString(this._address + (long)this._size)));
            }
            return this._outStore.write(address, buffer, offset, length);
        }

        @Override
        public OutStore clone() {
            return new OutStoreFacade(this._address, this._size);
        }

        @Override
        public void close() {
            OutStoreMmapNio outStore = this._outStore;
            this._outStore = null;
            if (outStore != null && outStore.getSequence() == StoreReadWriteMmapNio.this._storeSequence.get()) {
                StoreReadWriteMmapNio.this._freeOutStore.free(outStore);
            }
        }
    }

    class InStoreImpl
    implements InStore {
        private final MmapFile[] _mmapFile;
        private final ByteBuffer[] _mmap;
        private final long _sequence;

        InStoreImpl() {
            this._sequence = StoreReadWriteMmapNio.this._storeSequence.get();
            this._mmapFile = StoreReadWriteMmapNio.this._mmapFileChunks;
            int indexEnd = (int)((StoreReadWriteMmapNio.this.getFileSize() - 1L) / StoreReadWriteMmapNio.this._mmapChunkSize);
            this._mmap = new ByteBuffer[indexEnd + 1];
            MappedByteBuffer lastBuffer = null;
            for (int i = 0; i < this._mmap.length; ++i) {
                MmapFile mmapFile = this._mmapFile[i];
                if (lastBuffer != mmapFile.getByteBuffer()) {
                    this._mmap[i] = mmapFile.getByteBuffer().duplicate();
                    lastBuffer = mmapFile.getByteBuffer();
                    continue;
                }
                this._mmap[i] = this._mmap[i - 1];
            }
        }

        public long getSequence() {
            return this._sequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean read(long address, byte[] buffer, int offset, int length) {
            while (length > 0) {
                ByteBuffer mmap;
                int mmapIndex = (int)(address / StoreReadWriteMmapNio.this._mmapChunkSize);
                ByteBuffer byteBuffer = mmap = this._mmap[mmapIndex];
                synchronized (byteBuffer) {
                    MmapFile mmapFile = this._mmapFile[mmapIndex];
                    int mmapOffset = (int)(address - mmapFile.getAddress());
                    int sublen = (int)Math.min((long)length, mmapFile.getSize() - (long)mmapOffset);
                    mmap.limit(mmapOffset + sublen);
                    mmap.position(mmapOffset);
                    mmap.get(buffer, offset, sublen);
                    offset += sublen;
                    length -= sublen;
                    address += (long)sublen;
                }
            }
            return true;
        }

        @Override
        public InStore clone() {
            throw new IllegalStateException();
        }

        @Override
        public void close() {
            throw new IllegalStateException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + StoreReadWriteMmapNio.this._path + "]";
        }
    }

    class InStoreFacade
    implements InStore {
        private InStoreImpl _delegate;
        private long _address;
        private int _size;

        InStoreFacade(long address, int size) {
            this._delegate = StoreReadWriteMmapNio.this.allocateRead();
            this._address = address;
            this._size = size;
        }

        @Override
        public boolean read(long address, byte[] buffer, int offset, int length) {
            if (address < this._address) {
                throw new IllegalStateException();
            }
            if (this._address + (long)this._size < (long)(offset + length)) {
                throw new IllegalStateException();
            }
            return this._delegate.read(address, buffer, offset, length);
        }

        @Override
        public InStore clone() {
            return new InStoreFacade(this._address, this._size);
        }

        @Override
        public void close() {
            InStoreImpl delegate = this._delegate;
            this._delegate = null;
            if (delegate != null && delegate.getSequence() == StoreReadWriteMmapNio.this._storeSequence.get()) {
                StoreReadWriteMmapNio.this._freeInStore.free(delegate);
            }
        }
    }

    private class MmapFile {
        private MappedByteBuffer _mmap;
        private final long _address;
        private final int _size;
        private final AtomicBoolean _isDirty = new AtomicBoolean();

        public MmapFile(FileChannel channel, long address, int size) throws IOException {
            this._mmap = channel.map(FileChannel.MapMode.READ_WRITE, address, size);
            this._address = address;
            this._size = size;
        }

        public long getAddress() {
            return this._address;
        }

        public long getSize() {
            return this._size;
        }

        MappedByteBuffer getByteBuffer() {
            return this._mmap;
        }

        public void setDirty() {
            this._isDirty.set(true);
        }

        public void fsyncImpl() {
            MappedByteBuffer mmap = this._mmap;
            try {
                if (mmap != null) {
                    mmap.force();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void close() {
            MappedByteBuffer mmap = this._mmap;
            this._mmap = null;
            try {
                if (mmap != null) {
                    mmap.force();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                StoreReadWriteMmapNio.this._channel.force(true);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Long.toHexString(StoreReadWriteMmapNio.this._fileSize) + "]";
        }
    }
}

