/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.jdbc.GeneratedKeysResultSet;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import java.sql.SQLException;

class AutoIncrementExpr
extends Expr {
    private Table _table;

    AutoIncrementExpr(Table table) {
        this._table = table;
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        long value = this._table.nextAutoIncrement(context);
        GeneratedKeysResultSet keysRS = context.getGeneratedKeysResultSet();
        if (keysRS != null) {
            Column column = this._table.getAutoIncrementColumn();
            keysRS.setColumn(2, column);
            keysRS.setLong(2, value);
        }
        return value;
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this.evalLong(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    public String toString() {
        return "auto_increment()";
    }
}

