/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.AbstractBinaryExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class BinaryLongExpr
extends AbstractBinaryExpr {
    private Expr _left;
    private Expr _right;
    private int _op;

    BinaryLongExpr(Expr left, Expr right, int op) {
        this._left = left;
        this._right = right;
        this._op = op;
    }

    @Override
    public final Expr getLeft() {
        return this._left;
    }

    @Override
    public final Expr getRight() {
        return this._right;
    }

    @Override
    public Expr create(Expr left, Expr right) {
        return new BinaryLongExpr(left, right, this._op);
    }

    public Expr bind(FromItem[] fromItems) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        switch (this._op) {
            case 43: {
                return this._left.evalLong(context) + this._right.evalLong(context);
            }
            case 45: {
                return this._left.evalLong(context) - this._right.evalLong(context);
            }
            case 42: {
                return this._left.evalLong(context) * this._right.evalLong(context);
            }
            case 47: {
                return this._left.evalLong(context) / this._right.evalLong(context);
            }
            case 37: {
                return this._left.evalLong(context) % this._right.evalLong(context);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        return this.evalLong(context);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return String.valueOf(this.evalLong(context));
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public boolean equals(Object o) {
        if (o == null || !BinaryLongExpr.class.equals(o.getClass())) {
            return false;
        }
        BinaryLongExpr expr = (BinaryLongExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        switch (this._op) {
            case 43: {
                return "(" + this._left + " + " + this._right + ")";
            }
            case 45: {
                return "(" + this._left + " - " + this._right + ")";
            }
            case 42: {
                return "(" + this._left + " * " + this._right + ")";
            }
            case 47: {
                return "(" + this._left + " / " + this._right + ")";
            }
            case 37: {
                return "(" + this._left + " % " + this._right + ")";
            }
        }
        throw new IllegalStateException();
    }
}

