/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class BooleanLiteralExpr
extends Expr {
    private static BooleanLiteralExpr TRUE_EXPR = new BooleanLiteralExpr(true);
    private static BooleanLiteralExpr FALSE_EXPR = new BooleanLiteralExpr(false);
    private final boolean _value;

    private BooleanLiteralExpr(boolean value) {
        this._value = value;
    }

    static BooleanLiteralExpr create(boolean value) {
        return value ? TRUE_EXPR : FALSE_EXPR;
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return 0L;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        return this._value ? "1" : "0";
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        return this._value ? 1 : 0;
    }

    public String toString() {
        return this._value ? "TRUE" : "FALSE";
    }
}

