/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.CmpExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import java.sql.SQLException;
import java.util.ArrayList;

class DoubleCmpExpr
extends Expr {
    private Expr _left;
    private Expr _right;
    private int _op;

    DoubleCmpExpr(int op, Expr left, Expr right) {
        this._left = left;
        this._right = right;
        this._op = op;
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        if (this._left == newLeft && this._right == newRight) {
            return this;
        }
        return new CmpExpr(newLeft, newRight, this._op);
    }

    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._left.isNull(context) || this._right.isNull(context)) {
            return -1;
        }
        switch (this._op) {
            case 157: {
                if (this._left.evalDouble(context) < this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
            case 158: {
                if (this._left.evalDouble(context) <= this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
            case 159: {
                if (this._left.evalDouble(context) > this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
            case 160: {
                if (this._left.evalDouble(context) >= this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
            case 156: {
                if (this._left.evalDouble(context) != this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
            case 155: {
                if (this._left.evalDouble(context) == this._right.evalDouble(context)) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException("can't compare");
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return "(" + this._left + " = " + this._right + ")";
    }
}

