/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.vfs.PersistentDependency;
import java.util.logging.Logger;

public class RepositoryDependency
implements PersistentDependency {
    private String _tag;
    private String _sha1;
    private transient RepositorySpi _repository;

    public RepositoryDependency(String tag, String sha1) {
        this._tag = tag;
        this._sha1 = sha1;
        this._repository = RepositorySystem.getCurrentRepositorySpi();
    }

    @Override
    public boolean isModified() {
        String value = this.getRepository().getTagContentHash(this._tag);
        if (this._sha1 != null && !this._sha1.equals(value)) {
            return true;
        }
        return this._sha1 == null && value != null;
    }

    private RepositorySpi getRepository() {
        return this._repository;
    }

    @Override
    public boolean logModified(Logger log) {
        if (!this.isModified()) {
            return false;
        }
        log.info(this._tag + " is modified. old-hash=" + this._sha1 + " new-hash=" + this.getRepository().getTagContentHash(this._tag));
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryDependency)) {
            return false;
        }
        RepositoryDependency depend = (RepositoryDependency)obj;
        return this._tag.equals(depend._tag);
    }

    @Override
    public String getJavaCreateString() {
        return "new " + this.getClass().getName() + "(\"" + this._tag + "\", \"" + this._sha1 + "\")";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tag + "," + this._sha1 + "]";
    }
}

