/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.config.ConfigException;
import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.thread1.ResinThread1;
import com.caucho.env.thread1.ThreadLauncher1;
import com.caucho.env.thread1.ThreadTask1;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool1 {
    private static final L10N L = new L10N(ThreadPool1.class);
    private static final Logger log = Logger.getLogger(ThreadPool1.class.getName());
    public static final String THREAD_FULL_EVENT = "caucho.thread.schedule.full";
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private static final int DEFAULT_EXECUTOR_TASK_MAX = 16;
    private static final long PRIORITY_TIMEOUT = 10L;
    private static final int THREAD_IDLE_MIN = 16;
    private static final int THREAD_IDLE_MAX = 1024;
    private static final int THREAD_THROTTLE_LIMIT = 100;
    private static final long THREAD_THROTTLE_SLEEP = 10L;
    private static final NullRunnable NULL_RUNNABLE = new NullRunnable();
    private static final AtomicReference<ThreadPool1> _globalThreadPool = new AtomicReference();
    private final String _name;
    private int _executorTaskMax = 16;
    private final ThreadLauncher1 _launcher;
    private final Lifecycle _lifecycle = new Lifecycle();
    private final AtomicLong _resetCount = new AtomicLong();
    private final AtomicLong _overflowCount = new AtomicLong();
    private final AtomicReference<ThreadNode> _idleHead = new AtomicReference();
    private final AtomicReference<ThreadNode> _priorityIdleHead = new AtomicReference();
    private final ConcurrentLinkedQueue<ThreadTask1> _taskQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ThreadTask1> _priorityQueue = new ConcurrentLinkedQueue();
    private int _waitCount;
    private final Object _executorLock = new Object();
    private int _executorTaskCount;
    private ExecutorQueueItem _executorQueueHead;
    private ExecutorQueueItem _executorQueueTail;

    public ThreadPool1() {
        this("system");
    }

    public ThreadPool1(String name) {
        this._name = name;
        this._launcher = new ThreadLauncher1(this);
        this._launcher.setIdleMin(16);
        this._launcher.setIdleMax(1024);
        this._launcher.setThrottleLimit(100);
        this._launcher.setThrottleSleepTime(10L);
        this.init();
    }

    public static ThreadPool1 getCurrent() {
        return ThreadPool1.getThreadPool();
    }

    public static ThreadPool1 getThreadPool() {
        ThreadPool1 pool = _globalThreadPool.get();
        if (pool == null) {
            throw new IllegalStateException();
        }
        return pool;
    }

    protected void setAsGlobal(ThreadPool1 threadPool) {
        _globalThreadPool.set(threadPool);
    }

    public void setThreadMax(int max) {
        this._launcher.setThreadMax(max);
    }

    public int getThreadMax() {
        return this._launcher.getThreadMax();
    }

    public void setIdleMin(int min) {
        this._launcher.setIdleMin(min);
    }

    public int getIdleMin() {
        return this._launcher.getIdleMin();
    }

    public int getIdleMax() {
        return this._launcher.getIdleMax();
    }

    public void setIdleMax(int idleMax) {
        this._launcher.setIdleMax(idleMax);
    }

    public void setIdleTimeout(long timeout) {
        this._launcher.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this._launcher.getIdleTimeout();
    }

    public void setPriorityIdleMin(int priority) {
        this._launcher.setPriorityIdleMin(priority);
    }

    public int getPriorityIdleMin() {
        return this._launcher.getPriorityIdleMin();
    }

    public void setThrottlePeriod(long period) {
        this._launcher.setThrottlePeriod(period);
    }

    public void setThrottleLimit(int limit) {
        this._launcher.setThrottleLimit(limit);
    }

    public void setThrottleSleepTime(long period) {
        this._launcher.setThrottleSleepTime(period);
    }

    public void setExecutorTaskMax(int max) {
        if (this.getThreadMax() < max) {
            throw new ConfigException(L.l("<thread-executor-max> ({0}) must be less than <thread-max> ({1})", max, this.getThreadMax()));
        }
        if (max == 0) {
            throw new ConfigException(L.l("<thread-executor-max> must not be zero."));
        }
        this._executorTaskMax = max;
    }

    public int getExecutorTaskMax() {
        return this._executorTaskMax;
    }

    public int getThreadCount() {
        return this._launcher.getThreadCount();
    }

    public int getThreadActiveCount() {
        return this.getThreadCount() - this.getThreadIdleCount() - this.getPriorityIdleCount();
    }

    public int getThreadStartingCount() {
        return this._launcher.getStartingCount();
    }

    public int getThreadIdleCount() {
        return this._launcher.getIdleCount();
    }

    public int getPriorityIdleCount() {
        return this._launcher.getPriorityIdleCount();
    }

    public int getThreadWaitCount() {
        return this._waitCount;
    }

    public int getFreeThreadCount() {
        return this.getThreadMax() - this.getThreadCount() - this._launcher.getStartingCount();
    }

    public long getThreadCreateCountTotal() {
        return this._launcher.getCreateCountTotal();
    }

    public long getThreadOverflowCountTotal() {
        return this._overflowCount.get();
    }

    public int getThreadPriorityQueueSize() {
        return this._priorityQueue.size();
    }

    public int getThreadTaskQueueSize() {
        return this._taskQueue.size();
    }

    private void init() {
        this.update();
    }

    private void update() {
        this._launcher.update();
    }

    public void start() {
        this._launcher.start();
    }

    public boolean schedule(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
    }

    public boolean schedule(Runnable task, ClassLoader loader) {
        boolean isPriority = false;
        boolean isQueue = true;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
    }

    public boolean schedule(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = true;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    public void schedulePriority(Runnable task) {
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = CurrentTime.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true)) {
            String msg = this + " unable to schedule priority thread " + task + " pri-min=" + this.getPriorityIdleMin() + " thread=" + this.getThreadCount() + " idle=" + this.getThreadIdleCount() + " pri-idle=" + this.getPriorityIdleCount() + " starting=" + this.getThreadStartingCount() + " max=" + this.getThreadMax();
            log.warning(msg);
            OverflowThread item = new OverflowThread(task);
            item.start();
            HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleExecutorTask(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object object = this._executorLock;
        synchronized (object) {
            ++this._executorTaskCount;
            if (this._executorTaskCount <= this._executorTaskMax || this._executorTaskMax < 0) {
                boolean isPriority = false;
                boolean isQueue = true;
                return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
            }
            ExecutorQueueItem item = new ExecutorQueueItem(task, loader);
            if (this._executorQueueTail != null) {
                this._executorQueueTail._next = item;
            } else {
                this._executorQueueHead = item;
            }
            this._executorQueueTail = item;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExecutorTask() {
        ExecutorQueueItem item = null;
        Object object = this._executorLock;
        synchronized (object) {
            --this._executorTaskCount;
            assert (this._executorTaskCount >= 0);
            if (this._executorQueueHead != null) {
                item = this._executorQueueHead;
                this._executorQueueHead = item._next;
                if (this._executorQueueHead == null) {
                    this._executorQueueTail = null;
                }
            }
        }
        if (item != null) {
            Runnable task = item.getRunnable();
            ClassLoader loader = item.getLoader();
            boolean isPriority = false;
            boolean isQueue = true;
            this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
        }
    }

    public boolean start(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, 0x3FFFFFFFFFFFFFFFL, isPriority, isQueue);
    }

    public boolean start(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = false;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    public void startPriority(Runnable task) {
        boolean isQueue;
        boolean isPriority;
        long expire;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!this.scheduleImpl(task, loader, expire = CurrentTime.getCurrentTimeActual() + 10L, isPriority = true, isQueue = true)) {
            String msg = this + " unable to start priority thread " + task + " pri-min=" + this.getPriorityIdleMin() + " thread=" + this.getThreadCount() + " idle=" + this.getThreadIdleCount() + " pri-idle=" + this.getPriorityIdleCount() + " starting=" + this.getThreadStartingCount() + " max=" + this.getThreadMax();
            log.warning(msg);
            HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, msg);
            OverflowThread item = new OverflowThread(task);
            item.start();
        }
    }

    public boolean startPriority(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : CurrentTime.getCurrentTimeActual() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean isPriority = true;
        boolean isQueue = false;
        return this.scheduleImpl(task, loader, expire, isPriority, isQueue);
    }

    private boolean scheduleImpl(Runnable task, ClassLoader loader, long expireTime, boolean isPriority, boolean isQueueIfFull) {
        if (this.scheduleIdle(task, loader, isPriority)) {
            return true;
        }
        if (!isQueueIfFull && this._launcher.isThreadMax()) {
            throw new IllegalStateException(L.l("Thread pool full"));
        }
        Thread requestThread = null;
        if (!isQueueIfFull) {
            requestThread = Thread.currentThread();
        }
        ThreadTask1 taskItem = new ThreadTask1(task, loader, requestThread);
        if (isPriority) {
            this._priorityQueue.offer(taskItem);
        } else {
            this._taskQueue.offer(taskItem);
        }
        ResinThread1 thread = this.popIdleThread();
        if (thread != null) {
            thread.scheduleTask(NULL_RUNNABLE, null);
        } else if (isPriority && (thread = this.popPriorityThread()) != null) {
            thread.scheduleTask(NULL_RUNNABLE, null);
        }
        this._launcher.wake();
        if (!isQueueIfFull) {
            taskItem.park(expireTime);
        }
        return true;
    }

    private boolean scheduleIdle(Runnable task, ClassLoader loader, boolean isPriority) {
        ResinThread1 thread;
        if (!this._priorityQueue.isEmpty()) {
            return false;
        }
        if ((this._taskQueue.isEmpty() || isPriority) && (thread = this.popIdleThread()) != null) {
            thread.scheduleTask(task, loader);
            return true;
        }
        if (!isPriority) {
            return false;
        }
        ResinThread1 priorityThread = this.popPriorityThread();
        if (priorityThread != null) {
            priorityThread.scheduleTask(task, loader);
            return true;
        }
        return false;
    }

    void startIdleThread() {
        this._launcher.wake();
    }

    void beginIdle(ResinThread1 thread) {
        if (this._launcher.beginPriorityIdle()) {
            this.pushIdleThread(this._priorityIdleHead, thread);
        } else {
            this._launcher.onChildIdleBegin();
            this.pushIdleThread(this._idleHead, thread);
        }
        ThreadTask1 item = this.nextQueueTask();
        if (item == null) {
            return;
        }
        ResinThread1 itemThread = this.popIdleThread();
        if (itemThread == null) {
            itemThread = this.popPriorityThread();
        }
        if (itemThread != null) {
            itemThread.scheduleTask(item.getRunnable(), item.getLoader());
            item.wake();
        } else {
            this._priorityQueue.offer(item);
            this._launcher.wake();
        }
    }

    private ThreadTask1 nextQueueTask() {
        int idleCount;
        int priorityIdleCount;
        ThreadTask1 item = this._priorityQueue.poll();
        if (item != null) {
            return item;
        }
        if (this._taskQueue.size() == 0) {
            return null;
        }
        int priorityIdleMin = this._launcher.getPriorityIdleMin();
        if (priorityIdleMin <= (priorityIdleCount = this._launcher.getPriorityIdleCount()) + (idleCount = this._launcher.getIdleCount())) {
            return this._taskQueue.poll();
        }
        return null;
    }

    private ResinThread1 popIdleThread() {
        ResinThread1 thread = this.popIdleThread(this._idleHead);
        if (thread != null) {
            this._launcher.onChildIdleEnd();
        }
        return thread;
    }

    private ResinThread1 popPriorityThread() {
        ResinThread1 thread = this.popIdleThread(this._priorityIdleHead);
        if (thread != null) {
            this._launcher.onPriorityIdleEnd();
        }
        return thread;
    }

    private void pushIdleThread(AtomicReference<ThreadNode> idleHeadRef, ResinThread1 thread) {
        ThreadNode next;
        ThreadNode head = new ThreadNode(thread);
        do {
            next = idleHeadRef.get();
            head.setNext(next);
        } while (!idleHeadRef.compareAndSet(next, head));
    }

    private ResinThread1 popIdleThread(AtomicReference<ThreadNode> idleHeadRef) {
        ThreadNode next;
        ThreadNode head;
        do {
            if ((head = idleHeadRef.get()) != null) continue;
            return null;
        } while (!idleHeadRef.compareAndSet(head, next = head.getNext()));
        return head.getThread();
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void reset() {
        this._resetCount.incrementAndGet();
    }

    public void closeEnvironment(ClassLoader env) {
        this.reset();
    }

    public void interrupt() {
        ResinThread1 thread;
        while ((thread = this.popIdleThread()) != null) {
            thread.close();
        }
    }

    public void close() {
        if (this == _globalThreadPool.get()) {
            throw new IllegalStateException(L.l("Cannot close global thread pool"));
        }
        this._lifecycle.toDestroy();
        this._launcher.destroy();
        this.interrupt();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    static final class ThreadNode {
        private final ResinThread1 _thread;
        private ThreadNode _next;

        ThreadNode(ResinThread1 thread) {
            this._thread = thread;
        }

        ResinThread1 getThread() {
            return this._thread;
        }

        void setNext(ThreadNode next) {
            this._next = next;
        }

        ThreadNode getNext() {
            return this._next;
        }
    }

    static class NullRunnable
    implements Runnable {
        NullRunnable() {
        }

        @Override
        public void run() {
        }
    }

    static class ExecutorQueueItem {
        Runnable _runnable;
        ClassLoader _loader;
        ExecutorQueueItem _next;

        ExecutorQueueItem(Runnable runnable, ClassLoader loader) {
            this._runnable = runnable;
            this._loader = loader;
        }

        Runnable getRunnable() {
            return this._runnable;
        }

        ClassLoader getLoader() {
            return this._loader;
        }
    }

    final class OverflowThread
    extends Thread {
        private Runnable _task;
        private ClassLoader _loader;

        OverflowThread(Runnable task) {
            super("resin-overflow-" + task.getClass().getSimpleName());
            this.setDaemon(true);
            this._task = task;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(this._loader);
            try {
                ThreadPool1.this._overflowCount.incrementAndGet();
                this._task.run();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

