/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.warning;

import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.warning.WarningHandler;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WarningService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 1;
    private static final Logger log = Logger.getLogger(WarningService.class.getName());
    private final CopyOnWriteArrayList<WarningHandler> _priorityHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<WarningHandler> _handlers = new CopyOnWriteArrayList();

    public static WarningService createAndAddService() {
        ResinSystem system = WarningService.preCreate(WarningService.class);
        WarningService service = new WarningService();
        system.addService(WarningService.class, service);
        return service;
    }

    public static WarningService getCurrent() {
        return ResinSystem.getCurrentService(WarningService.class);
    }

    public void sendWarning(Object source, String msg) {
        try {
            String s = "WarningService: " + msg;
            System.err.println(s);
            for (WarningHandler handler : this._priorityHandlers) {
                handler.warning(source, msg);
            }
            for (WarningHandler handler : this._handlers) {
                handler.warning(source, msg);
            }
            log.warning(s);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void sendWarning(Object source, Throwable e) {
        try {
            e.printStackTrace();
            String msg = e.toString();
            String s = "WarningService: " + e;
            System.err.println(s);
            for (WarningHandler handler : this._priorityHandlers) {
                try {
                    handler.warning(source, msg);
                }
                catch (Throwable e1) {
                    log.log(Level.WARNING, e1.toString(), e1);
                }
            }
            for (WarningHandler handler : this._handlers) {
                try {
                    handler.warning(source, msg);
                }
                catch (Throwable e1) {
                    log.log(Level.WARNING, e1.toString(), e1);
                }
            }
            log.warning(s);
        }
        catch (Throwable e1) {
            log.log(Level.WARNING, e1.toString(), e1);
        }
    }

    public static void sendCurrentWarning(Object source, String msg) {
        WarningService warning = WarningService.getCurrent();
        if (warning != null) {
            warning.sendWarning(source, msg);
        } else {
            System.err.println(msg);
            log.warning(msg);
        }
    }

    public static void sendCurrentWarning(Object source, Throwable e) {
        WarningService warning = WarningService.getCurrent();
        if (warning != null) {
            warning.sendWarning(source, e);
        } else {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void addHandler(WarningHandler handler) {
        this._handlers.add(handler);
    }

    public void addPriorityHandler(WarningHandler handler) {
        this._priorityHandlers.add(handler);
    }

    @Override
    public int getStartPriority() {
        return 1;
    }
}

