/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.ra;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.dbpool.ConnectionPool;
import com.caucho.jca.cfg.ConnectionDefinition;
import com.caucho.jca.cfg.MessageListenerConfig;
import com.caucho.jca.ra.ObjectConfig;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import com.caucho.jca.ra.ResourceManagerImpl;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class ConnectorResource
implements EnvironmentListener {
    private static L10N L = new L10N(ConnectorResource.class);
    private static Logger log = Logger.getLogger(ConnectorResource.class.getName());
    private static int _idGen;
    private String _url;
    private String _name;
    private String _jndiName;
    private String _type;
    private ResourceArchive _rar;
    private ResourceAdapterConfig _resourceAdapter = new ResourceAdapterConfig();
    private ContainerProgram _init;
    private ArrayList<ConnectionFactory> _outboundList = new ArrayList();
    private ArrayList<ConnectionListener> _inboundList = new ArrayList();
    private ArrayList<ConnectorBean> _beanList = new ArrayList();
    private ResourceAdapter _ra;
    private boolean _isInitRA;
    private final Lifecycle _lifecycle = new Lifecycle();

    public void setName(String name) {
        this._name = name;
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(String type) throws Exception {
        this.setClass(type);
    }

    public void setURL(String url) throws Exception {
    }

    public void setClass(String type) throws Exception {
        this._type = type;
        this._rar = ResourceArchiveManager.findResourceArchive(this._type);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this._rar != null) {
            com.caucho.jca.cfg.ResourceAdapterConfig raConfig = this._rar.getResourceAdapter();
            if (raConfig.getType() != null) {
                this._ra = (ResourceAdapter)raConfig.instantiate();
            }
        } else {
            try {
                Class<?> raClass = Class.forName(this._type, false, loader);
                this._ra = (ResourceAdapter)raClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigException(L.l("'{0}' is not a known connector.  The type must match the resource adaptor or managed connection factory of one of the installed *.rar files or specify a ResourceAdapter implementation.", (Object)this._type), e);
            }
        }
    }

    public String getType() {
        return this._type;
    }

    public void addInit(ContainerProgram init) {
        this._init = init;
    }

    public ResourceAdapterConfig createResourceAdapter() throws ConfigException {
        if (this._ra == null) {
            throw new ConfigException(L.l("'{0}' may not have a <resource-adapter> section.  Old-style connectors must use <connection-factory>, but not <resource-adapter>.", (Object)this._type));
        }
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapterConfig raConfig) throws Exception {
    }

    public ConnectionFactory createConnectionFactory() throws Exception {
        this.initRA();
        return new ConnectionFactory();
    }

    public void addConnectionFactory(ConnectionFactory factory) throws Exception {
        this._outboundList.add(factory);
    }

    public ConnectionListener createMessageListener() throws Exception {
        this.initRA();
        return new ConnectionListener();
    }

    public void addMessageListener(ConnectionListener listener) throws Throwable {
        ActivationSpec activationSpec;
        this._inboundList.add(listener);
        String listenerType = listener.getType();
        if (this._ra == null) {
            throw new ConfigException(L.l("message-listener requires a resource-adapter."));
        }
        if (this._rar != null) {
            MessageListenerConfig objectCfg = this._rar.getMessageListener(listenerType);
            if (objectCfg == null) {
                throw new ConfigException(L.l("`{0}' is an unknown type of <connection-listener> for `{1}'.  The connector has no matching inbound connection-listener.", (Object)listenerType, (Object)this._type));
            }
            activationSpec = (ActivationSpec)objectCfg.instantiate();
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> listenerClass = null;
            try {
                listenerClass = Class.forName(listenerType, false, loader);
            }
            catch (Throwable e) {
                throw new ConfigException(L.l("`{0}' is not a known listener.  The type must match the activation spec for an inbound connection of one of the installed *.rar files or specify an ActivationSpec implementation.", (Object)listenerType), e);
            }
            activationSpec = (ActivationSpec)listenerClass.newInstance();
        }
        if (listener.getInit() != null) {
            listener.getInit().configure(activationSpec);
        }
        activationSpec.setResourceAdapter(this._ra);
        EndpointFactory endpointFactoryCfg = listener.getEndpointFactory();
        if (endpointFactoryCfg == null) {
            throw new ConfigException(L.l("connection-listener needs endpoint factory."));
        }
        Class endpointClass = endpointFactoryCfg.getType();
        MessageEndpointFactory endpointFactory = (MessageEndpointFactory)endpointClass.newInstance();
        if (endpointFactoryCfg.getInit() != null) {
            endpointFactoryCfg.getInit().configure(endpointFactory);
        }
        Config.init(endpointFactory);
        listener.setEndpoint(endpointFactory);
        listener.setActivation(activationSpec);
    }

    public ConnectorBean createBean() {
        return new ConnectorBean();
    }

    public ConnectorBean createResource() {
        return this.createBean();
    }

    @PostConstruct
    public void init() throws Exception {
        ConnectionDefinition factoryConfig;
        if (this._type == null) {
            throw new ConfigException(L.l("<connector> requires a <type>."));
        }
        if (this._name == null) {
            this._name = this._jndiName;
        }
        if (this._name == null && this._rar != null) {
            this._name = this._rar.getDisplayName() + "-" + _idGen++;
        }
        if (this._ra == null) {
            throw new ConfigException(L.l("<connector> does not have a resource adapter."));
        }
        if (this._resourceAdapter.getInit() != null) {
            this._resourceAdapter.getInit().configure(this._ra);
        }
        if (this._init != null) {
            this._init.configure(this._ra);
        }
        ResourceManagerImpl.addResource(this._ra);
        InjectManager manager = InjectManager.create();
        BeanBuilder<?> beanFactory = manager.createBeanFactory(this._ra.getClass());
        if (this._resourceAdapter.getName() != null) {
            Jndi.bindDeepShort(this._resourceAdapter.getName(), this._ra);
            beanFactory.name(this._resourceAdapter.getName());
        }
        manager.addBeanDiscover(beanFactory.singleton(this._ra));
        if (this._outboundList.size() == 0 && this._jndiName != null && this._rar != null && (factoryConfig = this._rar.getConnectionDefinition(null)) != null) {
            ConnectionFactory factory = this.createConnectionFactory();
            factory.setJndiName(this._jndiName);
            factory.init();
            this.addConnectionFactory(factory);
        }
        this.initRA();
        Environment.addEnvironmentListener(this);
        this.start();
        log.fine("Connector[" + this._type + "] active");
    }

    public void start() throws Exception {
        int i;
        if (!this._lifecycle.toActive()) {
            return;
        }
        this.initRA();
        for (i = 0; i < this._outboundList.size(); ++i) {
            ConnectionFactory factory = this._outboundList.get(i);
            factory.start();
        }
        for (i = 0; i < this._inboundList.size(); ++i) {
            ConnectionListener listener = this._inboundList.get(i);
            this._ra.endpointActivation(listener.getEndpoint(), listener.getActivation());
        }
    }

    public void initRA() throws Exception {
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        for (int i = 0; i < this._inboundList.size(); ++i) {
            ConnectionListener listener = this._inboundList.get(i);
            MessageEndpointFactory endpointFactory = listener.getEndpoint();
            ActivationSpec activation = listener.getActivation();
            if (this._ra == null) continue;
            this._ra.endpointDeactivation(endpointFactory, activation);
        }
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return "ConnectorResource[" + this._name + "]";
    }

    public class ConnectorBean {
        private String _name;
        private String _type;
        private ContainerProgram _init;
        private ObjectConfig _objectConfig;
        private Object _object;

        public void setJndiName(String name) {
            this._name = name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) throws Exception {
            this.setClass(type);
        }

        public void setClass(String type) throws Exception {
            this._type = type;
            Object resourceObject = null;
            if (ConnectorResource.this._rar != null) {
                this._objectConfig = ConnectorResource.this._rar.getAdminObject(type);
                if (this._objectConfig == null) {
                    throw new ConfigException(L.l("`{0}' may not have a <resource> section.  The connector has no matching <adminobject> defined.", (Object)this._type));
                }
                this._object = this._objectConfig.instantiate();
            } else {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> resourceClass = Class.forName(type, false, loader);
                    this._object = resourceClass.newInstance();
                }
                catch (Exception e) {
                    throw new ConfigException(L.l("`{0}' is not a known resource.  The type must match the adminobject of one of the installed *.rar files.", (Object)this._type), e);
                }
            }
        }

        public String getType() {
            return this._type;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        public ContainerProgram getInit() {
            return this._init;
        }

        public Object getObject() {
            return this._object;
        }

        @PostConstruct
        public void init() throws Exception {
            if (this._object == null) {
                throw new ConfigException(L.l("<class> must be set for a bean."));
            }
            Object resourceObject = this.getObject();
            if (this.getInit() != null) {
                this.getInit().configure(resourceObject);
            }
            if (ConnectorResource.this._ra != null && resourceObject instanceof ResourceAdapterAssociation) {
                ((ResourceAdapterAssociation)resourceObject).setResourceAdapter(ConnectorResource.this._ra);
            }
            InjectManager beanManager = InjectManager.create();
            BeanBuilder<?> factory = beanManager.createBeanFactory(resourceObject.getClass());
            if (this.getName() != null) {
                Jndi.bindDeepShort(this.getName(), resourceObject);
                beanManager.addBeanDiscover(factory.name(this.getName()).singleton(resourceObject));
            } else {
                beanManager.addBeanDiscover(factory.singleton(resourceObject));
            }
        }
    }

    public class EndpointFactory {
        private String _name;
        private Class _type;
        private ContainerProgram _init;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(Class type) throws ConfigException {
            this._type = type;
            Config.checkCanInstantiate(type);
        }

        public Class getType() {
            return this._type;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        public ContainerProgram getInit() {
            return this._init;
        }
    }

    public class ConnectionListener {
        private String _name;
        private String _type;
        private ContainerProgram _init;
        private EndpointFactory _endpointFactory;
        private MessageEndpointFactory _endpoint;
        private ActivationSpec _activation;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) {
            this._type = type;
        }

        public String getType() {
            return this._type;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        public ContainerProgram getInit() {
            return this._init;
        }

        public EndpointFactory getEndpointFactory() {
            return this._endpointFactory;
        }

        public EndpointFactory createEndpointFactory() {
            this._endpointFactory = new EndpointFactory();
            return this._endpointFactory;
        }

        @PostConstruct
        public void init() throws ConfigException {
            if (this._endpointFactory == null) {
                throw new ConfigException(L.l("connection-listener needs an endpoint-factory"));
            }
        }

        public void setEndpoint(MessageEndpointFactory endpoint) {
            this._endpoint = endpoint;
        }

        public MessageEndpointFactory getEndpoint() {
            return this._endpoint;
        }

        public void setActivation(ActivationSpec activation) {
            this._activation = activation;
        }

        public ActivationSpec getActivation() {
            return this._activation;
        }
    }

    public class ConnectionFactory {
        private String _name;
        private String _type;
        private ManagedConnectionFactory _factory;
        private boolean _localTransactionOptimization = true;
        private boolean _shareable = true;
        private ContainerProgram _init;

        public void setJndiName(String name) {
            this._name = name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setType(String type) throws Exception {
            this.setClass(type);
        }

        public void setClass(String type) throws Exception {
            this._type = type;
            if (ConnectorResource.this._rar != null) {
                ConnectionDefinition factoryConfig = ConnectorResource.this._rar.getConnectionDefinition(type);
                if (factoryConfig == null) {
                    throw new ConfigException(L.l("'{0}' is an unknown type of <connection-factory> for '{1}'.  The connector has no matching outbound connection-factory.", (Object)type, (Object)ConnectorResource.this._type));
                }
                this._factory = (ManagedConnectionFactory)factoryConfig.instantiate();
            } else if (type != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(type, false, loader);
                }
                catch (Exception e) {
                    throw new ConfigException(L.l("'{0}' is not a known connection factory.  The type must match the resource adaptor or managed connection factory of one of the installed *.rar files or specify a ManagedConnectionFactory implementation.", (Object)type));
                }
                if (!ManagedConnectionFactory.class.isAssignableFrom(factoryClass)) {
                    throw new ConfigException(L.l("'{0}' does not implement javax.resource.spi.ManagedConnectionFactory.  <connection-factory> classes must implement ManagedConnectionFactory.", (Object)factoryClass.getName()));
                }
                this._factory = (ManagedConnectionFactory)factoryClass.newInstance();
            }
        }

        public String getType() {
            return this._type;
        }

        public void setLocalTransactionOptimization(boolean enable) {
            this._localTransactionOptimization = enable;
        }

        public boolean getLocalTransactionOptimization() {
            return this._localTransactionOptimization;
        }

        public void setShareable(boolean enable) {
            this._shareable = enable;
        }

        public boolean getShareable() {
            return this._shareable;
        }

        public ManagedConnectionFactory getFactory() {
            return this._factory;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        public ContainerProgram getInit() {
            return this._init;
        }

        @PostConstruct
        public void init() throws Exception {
            if (this._factory == null && ConnectorResource.this._rar != null) {
                ConnectionDefinition factoryConfig = ConnectorResource.this._rar.getConnectionDefinition(null);
                this._factory = (ManagedConnectionFactory)factoryConfig.instantiate();
            }
            if (this._factory == null) {
                throw new ConfigException(L.l("connection-factory requires a valid type."));
            }
        }

        public void start() throws Exception {
            ManagedConnectionFactory managedFactory = this.getFactory();
            if (this.getInit() != null) {
                this.getInit().configure(managedFactory);
            }
            if (ConnectorResource.this._ra != null && managedFactory instanceof ResourceAdapterAssociation) {
                ((ResourceAdapterAssociation)managedFactory).setResourceAdapter(ConnectorResource.this._ra);
            }
            ResourceManagerImpl rm = ResourceManagerImpl.createLocalManager();
            ConnectionPool cm = rm.createConnectionPool();
            if (this._name != null) {
                cm.setName(this._name);
            }
            if (ConnectorResource.this._rar != null) {
                String trans = ConnectorResource.this._rar.getTransactionSupport();
                if (trans == null) {
                    cm.setXATransaction(true);
                    cm.setLocalTransaction(true);
                } else if (trans.equals("XATransaction")) {
                    cm.setXATransaction(true);
                    cm.setLocalTransaction(true);
                } else if (trans.equals("NoTransaction")) {
                    cm.setXATransaction(false);
                    cm.setLocalTransaction(false);
                } else if (trans.equals("LocalTransaction")) {
                    cm.setXATransaction(false);
                    cm.setLocalTransaction(true);
                }
            }
            cm.setLocalTransactionOptimization(this.getLocalTransactionOptimization());
            cm.setShareable(this.getShareable());
            Object connectionFactory = cm.init(managedFactory);
            cm.start();
            InjectManager beanManager = InjectManager.create();
            BeanBuilder<?> factory = beanManager.createBeanFactory(connectionFactory.getClass());
            if (this.getName() != null) {
                Jndi.bindDeepShort(this.getName(), connectionFactory);
                beanManager.addBeanDiscover(factory.name(this.getName()).singleton(connectionFactory));
            } else {
                beanManager.addBeanDiscover(factory.singleton(connectionFactory));
            }
        }
    }

    public class ResourceAdapterConfig {
        private String _name;
        private ContainerProgram _init;

        public void setJndiName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        public ContainerProgram getInit() {
            return this._init;
        }
    }
}

