/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemoryTopic;
import com.caucho.jms.queue.MessageAvailableListener;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class TemporaryTopicImpl
extends MemoryTopic
implements TemporaryTopic {
    private static final L10N L = new L10N(TemporaryTopicImpl.class);
    private static int _idCount;
    private JmsSession _session;
    private AtomicInteger _messageConsumerCount;
    private ArrayList<MessageAvailableListener> _consumerList = new ArrayList();

    TemporaryTopicImpl(JmsSession session) {
        this._session = session;
        this._messageConsumerCount = new AtomicInteger();
        this.setName("TemporaryTopic-" + _idCount++);
    }

    JmsSession getSession() {
        return this._session;
    }

    public void addMessageConsumer() {
        this._messageConsumerCount.incrementAndGet();
    }

    public void removeMessageConsumer() {
        this._messageConsumerCount.decrementAndGet();
    }

    public boolean isClosed() {
        return this.getSession() != null ? this.getSession().isClosed() : false;
    }

    public void delete() throws JMSException {
        if (this._messageConsumerCount.get() > 0) {
            throw new IllegalStateException(L.l("temporary topic is still active"));
        }
    }
}

