/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.config.inject.InjectManager;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.TaglibManager;
import com.caucho.jsp.el.JspExpressionFactoryImpl;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.jsp.JspApplicationContext;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final L10N L = new L10N(JspApplicationContextImpl.class);
    private static final EnvironmentLocal<JspApplicationContextImpl> _contextLocal = new EnvironmentLocal();
    private final WebApp _webApp;
    private final ExpressionFactory _expressionFactory;
    private TaglibManager _taglibManager;
    private PageManager _pageManager;
    private ELResolver[] _resolverArray = new ELResolver[0];
    private ELContextListener[] _listenerArray = new ELContextListener[0];
    private boolean _hasRequest;

    public JspApplicationContextImpl(WebApp webApp) {
        this._webApp = webApp;
        InjectManager injectManager = this._webApp.getBeanManager();
        JspExpressionFactoryImpl factory = new JspExpressionFactoryImpl(this);
        this._expressionFactory = injectManager.wrapExpressionFactory(factory);
        _contextLocal.set(this);
    }

    public static JspApplicationContextImpl getCurrent() {
        return _contextLocal.get();
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    public TaglibManager getTaglibManager() {
        return this._taglibManager;
    }

    public void setTaglibManager(TaglibManager taglibManager) {
        this._taglibManager = taglibManager;
    }

    public PageManager getPageManager() {
        if (this._pageManager == null) {
            throw new NullPointerException();
        }
        return this._pageManager;
    }

    public void setPageManager(PageManager pageManager) {
        this._pageManager = pageManager;
    }

    public void addELContextListener(ELContextListener listener) {
        if (this._hasRequest) {
            throw new IllegalStateException(L.l("Cannot add ELContextListener after requests have started."));
        }
        ELContextListener[] listenerArray = new ELContextListener[this._listenerArray.length + 1];
        System.arraycopy(this._listenerArray, 0, listenerArray, 0, this._listenerArray.length);
        listenerArray[this._listenerArray.length] = listener;
        this._listenerArray = listenerArray;
    }

    public ELContextListener[] getELListenerArray() {
        this._hasRequest = true;
        return this._listenerArray;
    }

    public void addELResolver(ELResolver resolver) {
        if (this._hasRequest) {
            throw new IllegalStateException(L.l("Can't add ELResolver after starting request."));
        }
        ELResolver[] resolverArray = new ELResolver[this._resolverArray.length + 1];
        System.arraycopy(this._resolverArray, 0, resolverArray, 0, this._resolverArray.length);
        resolverArray[this._resolverArray.length] = resolver;
        this._resolverArray = resolverArray;
    }

    public ELResolver[] getELResolverArray() {
        return this._resolverArray;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._expressionFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp + "]";
    }
}

