/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfNetwork
implements RequestPredicate {
    private static final Logger log = Logger.getLogger(IfNetwork.class.getName());
    static L10N L = new L10N(IfNetwork.class);
    private ArrayList<InetNetwork> _networkList = new ArrayList();
    private int _cacheSize = 256;
    private LruCache<String, Boolean> _cache;

    @Configurable
    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    @Configurable
    public void addValue(String network) throws UnknownHostException {
        if (this._networkList == null) {
            this._networkList = new ArrayList();
        }
        this._networkList.add(InetNetwork.create(network));
    }

    @PostConstruct
    public void init() throws ConfigException {
        this._cache = new LruCache(this._cacheSize);
    }

    @Override
    public boolean isMatch(HttpServletRequest request) {
        Boolean cacheValue;
        String remoteAddr = request.getRemoteAddr();
        if (remoteAddr == null) {
            return false;
        }
        if (this._cache != null && (cacheValue = this._cache.get(remoteAddr)) != null) {
            return cacheValue;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(remoteAddr);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        boolean isMatch = false;
        for (int i = 0; i < this._networkList.size(); ++i) {
            InetNetwork net = this._networkList.get(i);
            if (!net.isMatch(addr)) continue;
            isMatch = true;
            break;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " match=" + isMatch + " " + addr);
        }
        if (this._cache != null) {
            this._cache.put(remoteAddr, isMatch);
        }
        return isMatch;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this._networkList;
    }
}

