/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.CurrentTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfThrottle
implements RequestPredicate {
    private static final long DAY = 86400000L;
    private Map<String, Long> _map = new ConcurrentHashMap<String, Long>();
    private long _period = 60000L;
    private long _lastClearTime;

    public void setPeriod(Period period) {
        this._period = period.getPeriod();
    }

    @Override
    public boolean isMatch(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        if (remoteAddr == null) {
            return true;
        }
        long now = CurrentTime.getCurrentTime();
        Long oldTime = this._map.get(remoteAddr);
        boolean isThrottle = false;
        if (oldTime != null && now - oldTime < this._period) {
            isThrottle = true;
        }
        if (now - this._lastClearTime < 86400000L) {
            this._map.clear();
            this._lastClearTime = now;
        }
        this._map.put(remoteAddr, now);
        return isThrottle;
    }
}

