/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.proxy.ActorFor;
import com.caucho.bam.proxy.ReplyCallback;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployControllerService;
import com.caucho.env.deploy.DeployException;
import com.caucho.env.deploy.DeployTagItem;
import com.caucho.env.git.GitTree;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.server.deploy.DeployActorProxy;
import com.caucho.server.deploy.DeployControllerState;
import com.caucho.server.deploy.DeployTagResult;
import com.caucho.server.deploy.DeployTagStateQuery;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@ActorFor(api=DeployActorProxy.class)
public class DeployActor {
    private static final L10N L = new L10N(DeployActor.class);
    private static final Logger log = Logger.getLogger(DeployActor.class.getName());
    private static final String UID = "deploy";
    public static final String ADDRESS = "deploy@resin.caucho";
    private String _serverId;
    private RepositorySpi _repository;
    private final AtomicBoolean _isInit = new AtomicBoolean();

    public DeployActor() {
        this._serverId = ResinSystem.getCurrentId();
    }

    public void init() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        this._repository = RepositorySystem.getCurrentRepositorySpi();
        ManagedBroker broker = BamSystem.getCurrentBroker();
        BamManager bamManager = BamSystem.getCurrentManager();
        Mailbox mailbox = bamManager.createService(ADDRESS, this);
        String proxyAddress = "deploy@" + broker.getAddress();
        bamManager.addMailbox(proxyAddress, mailbox);
    }

    public String[] getCommitList(String[] commitList) {
        ArrayList<String> uncommittedList = new ArrayList<String>();
        if (commitList != null) {
            for (String commit : commitList) {
                if (this._repository.exists(commit)) continue;
                uncommittedList.add(commit);
            }
        }
        String[] result = new String[uncommittedList.size()];
        uncommittedList.toArray(result);
        return result;
    }

    public StreamSource getFile(String tag, String fileName) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " getFile(" + tag + "," + fileName + ")");
        }
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        RepositoryTagEntry entry = this._repository.getTagMap().get(tag);
        if (entry == null) {
            throw new ConfigException(L.l("'{0}' is an unknown repository tag", (Object)tag));
        }
        String sha1 = entry.getRoot();
        String fileSha = this.findFile(sha1, fileName, fileName);
        BlobStreamSource iss = new BlobStreamSource(this._repository, fileSha);
        return new StreamSource(iss);
    }

    private String findFile(String sha1, String fullFilename, String fileName) throws IOException {
        if (fileName.equals("")) {
            if (this._repository.isBlob(sha1)) {
                return sha1;
            }
            throw new ConfigException(L.l("'{0}' is not a file", (Object)fullFilename));
        }
        int p = fileName.indexOf(47);
        String tail = "";
        if (p > 0) {
            tail = fileName.substring(p + 1);
            fileName = fileName.substring(0, p);
        }
        if (!this._repository.isTree(sha1)) {
            throw new ConfigException(L.l("'{0}' is an invalid path", (Object)fullFilename));
        }
        GitTree tree = this._repository.readTree(sha1);
        String childSha1 = tree.getHash(fileName);
        if (childSha1 == null) {
            throw new ConfigException(L.l("'{0}' is an unknown file", (Object)fullFilename));
        }
        return this.findFile(childSha1, fullFilename, tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFile(String sha1, StreamSource source) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " sendFile sha1=" + sha1);
        }
        InputStream is = null;
        try {
            is = source.getInputStream();
            this._repository.writeRawGitFile(sha1, is);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtil.close(is);
        }
        return true;
    }

    public String[] listFiles(String tag, String fileName) throws IOException {
        RepositoryTagEntry entry;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " getFileList(" + tag + "," + fileName + ")");
        }
        if ((entry = this._repository.getTagMap().get(tag)) == null) {
            throw new ConfigException(L.l("'{0}' is an unknown repository tag", (Object)tag));
        }
        String sha1 = entry.getRoot();
        ArrayList<String> fileList = new ArrayList<String>();
        this.listFiles(fileList, sha1, "");
        Collections.sort(fileList);
        String[] files = new String[fileList.size()];
        fileList.toArray(files);
        return files;
    }

    private void listFiles(ArrayList<String> files, String sha1, String prefix) throws IOException {
        if (sha1 == null) {
            return;
        }
        if (this._repository.isBlob(sha1)) {
            files.add(prefix);
            return;
        }
        if (!this._repository.isTree(sha1)) {
            throw new ConfigException(L.l("'{0}' is an invalid path", (Object)prefix));
        }
        GitTree tree = this._repository.readTree(sha1);
        for (String key : tree.getMap().keySet()) {
            String name = "".equals(prefix) ? key : prefix + "/" + key;
            this.listFiles(files, tree.getHash(key), name);
        }
    }

    public boolean putTag(String tagName, String contentHash, Map<String, String> attributes) {
        if (contentHash == null) {
            throw new NullPointerException();
        }
        String server = "default";
        TreeMap<String, String> commitMetaData = new TreeMap<String, String>();
        if (attributes != null) {
            commitMetaData.putAll(attributes);
        }
        commitMetaData.put("server", server);
        return this._repository.putTag(tagName, contentHash, commitMetaData);
    }

    public boolean copyTag(String tag, String sourceTag, Map<String, String> attributes) {
        RepositoryTagEntry entry = this._repository.getTagMap().get(sourceTag);
        if (entry == null) {
            log.fine(this + " copyError dst='" + tag + "' src='" + sourceTag + "'");
            throw new DeployException(L.l("deploy-copy: '{0}' is an unknown source tag.", (Object)sourceTag));
        }
        log.fine(this + " copy dst='" + tag + "' src='" + sourceTag + "'");
        String server = "default";
        TreeMap<String, String> metaDataMap = new TreeMap<String, String>();
        if (attributes != null) {
            metaDataMap.putAll(attributes);
        }
        if (server != null) {
            metaDataMap.put("server", server);
        }
        return this._repository.putTag(tag, entry.getRoot(), metaDataMap);
    }

    public DeployTagResult[] queryTags(String regexp) {
        ArrayList<DeployTagResult> tags = new ArrayList<DeployTagResult>();
        Pattern pattern = Pattern.compile(regexp);
        for (Map.Entry<String, RepositoryTagEntry> entry : this._repository.getTagMap().entrySet()) {
            String tag = entry.getKey();
            if (!pattern.matcher(tag).find()) continue;
            tags.add(new DeployTagResult(tag, entry.getValue().getRoot()));
        }
        return tags.toArray(new DeployTagResult[tags.size()]);
    }

    public DeployTagStateQuery getTagState(String tag) {
        DeployControllerService deploy = DeployControllerService.getCurrent();
        DeployTagItem item = null;
        if (deploy != null) {
            deploy.update(tag);
            item = deploy.getTagItem(tag);
        }
        if (item != null) {
            return new DeployTagStateQuery(tag, item.getStateName(), item.getDeployException());
        }
        return null;
    }

    public boolean removeTag(String tag, Map<String, String> attributes) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " removeTag " + tag);
        }
        String server = "default";
        HashMap<String, String> commitMetaData = new HashMap<String, String>();
        if (attributes != null) {
            commitMetaData.putAll(attributes);
        }
        commitMetaData.put("server", server);
        return this._repository.removeTag(tag, commitMetaData);
    }

    public DeployControllerState start(String tag) {
        LifecycleState state = this.startImpl(tag);
        DeployControllerState result = new DeployControllerState(tag, state);
        log.fine(this + " start '" + tag + "' -> " + state.getStateName());
        return result;
    }

    private LifecycleState startImpl(String tag) {
        DeployControllerService service = DeployControllerService.getCurrent();
        DeployTagItem controller = service.getTagItem(tag);
        if (controller == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown controller", (Object)tag));
        }
        controller.toStart();
        return controller.getState();
    }

    public DeployControllerState stop(String tag) {
        LifecycleState state = this.stopImpl(tag);
        log.fine(this + " stop '" + tag + "' -> " + state.getStateName());
        return new DeployControllerState(tag, state);
    }

    private LifecycleState stopImpl(String tag) {
        DeployControllerService service = DeployControllerService.getCurrent();
        DeployTagItem controller = service.getTagItem(tag);
        if (controller == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown controller", (Object)tag));
        }
        controller.toStop();
        System.gc();
        return controller.getState();
    }

    public void controllerRestart(String tag, ReplyCallback<DeployControllerState> cb) {
        this.restart(tag, cb);
    }

    public void restart(String tag, ReplyCallback<DeployControllerState> cb) {
        this.restartImpl(tag, cb);
    }

    public void restartCluster(String tag, ReplyCallback<DeployControllerState> cb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    private void restartImpl(final String tag, final ReplyCallback<DeployControllerState> cb) {
        DeployControllerService service = DeployControllerService.getCurrent();
        final DeployTagItem controller = service.getTagItem(tag);
        if (controller == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown controller", (Object)tag));
        }
        ThreadPool.getCurrent().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    controller.toRestart();
                }
                finally {
                    cb.onReply(new DeployControllerState(tag, controller.getState()));
                }
            }
        });
    }

    public String getUid() {
        return UID;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    static class BlobStreamSource
    extends StreamSource {
        private RepositorySpi _repository;
        private String _sha1;

        BlobStreamSource(RepositorySpi repository, String sha1) {
            this._repository = repository;
            this._sha1 = sha1;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._repository.openRawGitFile(this._sha1);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this._repository.openRawGitFile(this._sha1);
        }
    }
}

