/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;

public class ServletMapping
extends ServletConfigImpl {
    private static final L10N L = new L10N(ServletMapping.class);
    private ArrayList<Mapping> _mappingList = new ArrayList();
    private boolean _isStrictMapping;
    private boolean _isRegexp;
    private boolean _ifAbsent;
    private boolean _isDefault;

    public void create(WebServlet webServlet) {
        if (webServlet.value().length > 0 && webServlet.urlPatterns().length == 0) {
            for (String string : webServlet.value()) {
                this.addURLPattern(string);
            }
        } else if (webServlet.urlPatterns().length > 0 && webServlet.value().length == 0) {
            for (String string : webServlet.urlPatterns()) {
                this.addURLPattern(string);
            }
        } else {
            throw new ConfigException(L.l("Annotation @WebServlet at '{0}' must specify either value or urlPatterns", (Object)this.getServletClassName()));
        }
        for (String string : webServlet.initParams()) {
            this.setInitParam(string.name(), string.value());
        }
        this.setLoadOnStartup(webServlet.loadOnStartup());
        this.setAsyncSupported(webServlet.asyncSupported());
    }

    public void setIfAbsent(boolean ifAbsent) {
        this._ifAbsent = ifAbsent;
    }

    public void addURLPattern(String pattern) {
        if (pattern.indexOf(10) > -1) {
            throw new ConfigException(L.l("'url-pattern' cannot contain newline"));
        }
        this._mappingList.add(new Mapping(pattern, null));
        if (this.getServletNameDefault() == null) {
            this.setServletNameDefault(pattern);
        }
    }

    public void addURLRegexp(String pattern) {
        this._mappingList.add(new Mapping(null, pattern));
    }

    public boolean isStrictMapping() {
        return this._isStrictMapping;
    }

    public void setStrictMapping(boolean isStrictMapping) {
        this._isStrictMapping = isStrictMapping;
    }

    public void setDefault(boolean isDefault) {
        this._isDefault = isDefault;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void init(ServletMapper mapper) throws ServletException {
        boolean hasInit = false;
        if (this.getServletName() == null) {
            this.setServletName(this.getServletNameDefault());
        }
        if (this.getServletName() != null && this.getServletName().indexOf("${") >= 0) {
            this._isRegexp = true;
        }
        if (this.getServletClassName() != null && this.getServletClassName().indexOf("${") >= 0) {
            this._isRegexp = true;
        }
        boolean ifAbsent = this._ifAbsent;
        for (int i = 0; i < this._mappingList.size(); ++i) {
            Mapping mapping = this._mappingList.get(i);
            String urlPattern = mapping.getUrlPattern();
            String urlRegexp = mapping.getUrlRegexp();
            if (this.getServletName() == null && this.getServletClassName() != null && urlPattern != null) {
                this.setServletName(urlPattern);
            }
            if (urlPattern != null && !hasInit) {
                hasInit = true;
                super.init();
                if (this.getServletClassName() != null) {
                    mapper.getServletManager().addServlet(this);
                }
            }
            if (urlPattern != null) {
                if (!mapper.addUrlMapping(urlPattern, this.getServletName(), this, ifAbsent)) continue;
                ifAbsent = false;
                continue;
            }
            mapper.addUrlRegexp(urlRegexp, this.getServletName(), this);
        }
    }

    Class<?> getServletClass(ArrayList<String> vars) {
        if (vars.size() > 1 || this._isRegexp) {
            return this.initRegexpClass(vars);
        }
        return this.getServletClass();
    }

    String initRegexpName(ArrayList<String> vars) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext(new MapVariableResolver(map));
        String rawName = this.getServletName();
        String rawClassName = this.getServletClassName();
        if (rawName == null) {
            rawName = rawClassName;
        }
        if (rawClassName == null) {
            rawClassName = rawName;
        }
        try {
            return EL.evalString(rawName, mapEnv);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    Class<?> initRegexpClass(ArrayList<String> vars) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext(new MapVariableResolver(map));
        String rawName = this.getServletName();
        String rawClassName = this.getServletClassName();
        if (rawName == null) {
            rawName = rawClassName;
        }
        if (rawClassName == null) {
            rawClassName = rawName;
        }
        try {
            String className = EL.evalString(rawClassName, mapEnv);
            try {
                WebApp app = (WebApp)this.getServletContext();
                return Class.forName(className, false, app.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    ServletMapping initRegexpConfig(ArrayList<String> vars) {
        if (vars.size() == 0 || !this._isRegexp) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext(new MapVariableResolver(map));
        String rawName = this.getServletName();
        String rawClassName = this.getServletClassName();
        if (rawName == null) {
            rawName = rawClassName;
        }
        if (rawClassName == null) {
            rawClassName = rawName;
        }
        try {
            String servletName = EL.evalString(rawName, mapEnv);
            String className = EL.evalString(rawClassName, mapEnv);
            ServletMapping config = new ServletMapping();
            config.setServletContext(this.getServletContext());
            config.setServletName(servletName);
            config.setServletClass(className);
            config.copyFrom(this);
            config.init();
            return config;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServletMapping[");
        for (int i = 0; i < this._mappingList.size(); ++i) {
            Mapping mapping = this._mappingList.get(i);
            if (mapping.getUrlPattern() != null) {
                builder.append("url-pattern=");
                builder.append(mapping.getUrlPattern());
                builder.append(", ");
                continue;
            }
            if (mapping.getUrlRegexp() == null) continue;
            builder.append("url-regexp=");
            builder.append(mapping.getUrlRegexp());
            builder.append(", ");
        }
        builder.append("name=");
        builder.append(this.getServletName());
        if (this.getServletClassName() != null) {
            builder.append(", class=");
            builder.append(this.getServletClassName());
        }
        builder.append("]");
        return builder.toString();
    }

    static class Mapping {
        private final String _urlPattern;
        private final String _urlRegexp;

        Mapping(String urlPattern, String urlRegexp) {
            this._urlPattern = urlPattern;
            this._urlRegexp = urlRegexp;
        }

        String getUrlPattern() {
            return this._urlPattern;
        }

        String getUrlRegexp() {
            return this._urlRegexp;
        }

        public String toString() {
            return "ServletMapping[" + this._urlPattern + ", " + this._urlRegexp + "]";
        }
    }
}

