/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.Config;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.host.HostRegexpVar;
import com.caucho.server.host.HostSingleDeployGenerator;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostRegexpDeployGenerator
extends DeployGenerator<HostController> {
    private static final Logger log = Logger.getLogger(HostSingleDeployGenerator.class.getName());
    private HostContainer _container;
    private HostConfig _config;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private ArrayList<HostController> _entries = new ArrayList();

    public HostRegexpDeployGenerator(DeployContainer<HostController> container) {
        super(container);
    }

    public HostRegexpDeployGenerator(DeployContainer<HostController> container, HostContainer hostContainer, HostConfig config) {
        super(container);
        this.setContainer(hostContainer);
        this._config = config;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setContainer(HostContainer container) {
        this._container = container;
    }

    @Override
    protected void fillDeployedNames(Set<String> names) {
        Pattern regexp = this._config.getRegexp();
        String pattern = regexp.pattern();
        String staticPattern = HostRegexpDeployGenerator.toStaticPattern(pattern);
        if (staticPattern != null) {
            names.add(staticPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateController(String name, ArrayList<HostController> list) {
        Pattern regexp = this._config.getRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.matches()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            String hostName = matcher.group();
            ArrayList<String> vars = new ArrayList<String>();
            HashMap<String, Object> varMap = new HashMap<String, Object>();
            for (int j = 0; j <= matcher.groupCount(); ++j) {
                vars.add(matcher.group(j));
                varMap.put("host" + j, matcher.group(j));
            }
            varMap.put("regexp", vars);
            varMap.put("host", new HostRegexpVar(hostName, vars));
            if (this._config.getHostName() != null) {
                try {
                    hostName = Config.evalString(this._config.getHostName(), varMap);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            String id = this._container.getServer().getStage() + "/host/" + name;
            Path rootDirectory = this._config.calculateRootDirectory(varMap);
            HostController controller = new HostController(id, rootDirectory, name, this._config, this._container, varMap);
            controller.setRegexpName(name);
            controller.setRegexp(regexp);
            controller.setRootDirectoryPattern(this._config.getRootDirectory());
            for (int i = 0; i < this._hostDefaults.size(); ++i) {
                controller.addConfigDefault(this._hostDefaults.get(i));
            }
            controller.init();
            Path rootDir = controller.getRootDirectory();
            if (rootDir == null || !rootDir.isDirectory()) {
                controller.destroy();
                return;
            }
            ArrayList<HostController> arrayList = this._entries;
            synchronized (arrayList) {
                for (int i = 0; i < this._entries.size(); ++i) {
                    HostController oldController = this._entries.get(i);
                    if (!rootDir.equals(oldController.getRootDirectory())) continue;
                    list.add(oldController);
                }
                this._entries.add(controller);
            }
            list.add(controller);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private static String toStaticPattern(String pattern) {
        StringBuilder sb = new StringBuilder();
        int len = pattern.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '\\': {
                    if (i + 1 < len && pattern.charAt(i + 1) == '.') {
                        sb.append('.');
                        ++i;
                    } else {
                        return null;
                    }
                }
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    return null;
                }
                case '$': 
                case '^': {
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._config + "]";
    }
}

