/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootServerConfig;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class BootPodConfig {
    private BootClusterConfig _clusterConfig;
    private String _id;
    private ContainerProgram _serverDefaultProgram = new ContainerProgram();
    private ContainerProgram _podProgram = new ContainerProgram();
    private ArrayList<BootServerConfig> _servers = new ArrayList();
    private CloudPod _cloudPod;

    public BootPodConfig(BootClusterConfig clusterConfig) {
        this._clusterConfig = clusterConfig;
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        this._id = id;
    }

    public BootClusterConfig getCluster() {
        return this._clusterConfig;
    }

    @Configurable
    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultProgram.addProgram(program);
    }

    public ContainerProgram getServerDefault() {
        return this._serverDefaultProgram;
    }

    @Configurable
    public BootServerConfig createServer() throws ConfigException {
        BootServerConfig server = new BootServerConfig(this);
        return server;
    }

    @Configurable
    public void addServer(BootServerConfig server) {
        this._servers.add(server);
    }

    public ArrayList<BootServerConfig> getServerList() {
        return this._servers;
    }

    public void addContentProgram(ConfigProgram program) {
        this._podProgram.addProgram(program);
    }

    ConfigProgram getProgram() {
        return this._podProgram;
    }

    @PostConstruct
    public void init() {
    }

    void initTopology(CloudPod cloudPod) {
        this._cloudPod = cloudPod;
        cloudPod.putData(new ClusterServerProgram(this._serverDefaultProgram));
        for (BootServerConfig bootServer : this._servers) {
            this.initTopology(bootServer);
        }
    }

    void initTopology(BootServerConfig bootServer) {
        CloudPod cloudPod = this._cloudPod;
        if (cloudPod == null) {
            this.getCluster().initTopology(this);
            cloudPod = this._cloudPod;
        }
        String id = bootServer.getId();
        String address = bootServer.getAddress();
        int port = bootServer.getPort();
        boolean isSecure = bootServer.isSecure();
        boolean isAllowExternal = bootServer.isAllowExternalAddress();
        CloudServer cloudServer = cloudPod.findServer(id);
        if (cloudServer == null) {
            cloudServer = bootServer.isExternalAddress() ? cloudPod.createExternalStaticServer(id, address, port, isSecure) : cloudPod.createStaticServer(id, address, port, isSecure, isAllowExternal);
        }
        bootServer.initTopology(cloudServer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

