/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import javax.servlet.http.Cookie;

public class CookieImpl
extends Cookie {
    private static final L10N L = new L10N(CookieImpl.class);
    private String _port;
    private SameSite _sameSite = SameSite.UNSET;

    public CookieImpl(String name, String value) {
        super(name, value);
    }

    public String getPort() {
        return this._port;
    }

    public void setPort(String port) {
        this._port = port;
    }

    public void setSameSite(String value) {
        this.setSameSite(SameSite.parseValue(value));
    }

    public void setSameSite(SameSite value) {
        this._sameSite = value == null ? SameSite.UNSET : value;
    }

    public SameSite getSameSite() {
        return this._sameSite;
    }

    public static enum SameSite {
        UNSET,
        NONE,
        LAX,
        STRICT;


        public static SameSite parseValue(String value) {
            if (value == null || value.equals("")) {
                return UNSET;
            }
            if (value.equals("Lax")) {
                return LAX;
            }
            if (value.equals("Strict")) {
                return STRICT;
            }
            if (value.equals("None")) {
                return NONE;
            }
            throw new ConfigException(L.l("cookie sameSite requires Lax, Strict, or None."));
        }
    }
}

