/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ContextFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(ContextFilterChain.class.getName());
    private FilterChain _next;
    private ClassLoader _classLoader;
    private TransactionManagerImpl _tm;
    private ErrorPageManager _errorPageManager;

    public ContextFilterChain(FilterChain next) {
        this._next = next;
        this._classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this._tm = TransactionManagerImpl.getInstance();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this._errorPageManager = errorPageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block26: {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._classLoader);
                this._next.doFilter(request, response);
            }
            catch (ServletException e) {
                if (this._errorPageManager != null) {
                    this._errorPageManager.sendServletError(e, request, response);
                    break block26;
                }
                throw e;
            }
            catch (IOException e) {
                if (this._errorPageManager != null) {
                    this._errorPageManager.sendServletError(e, request, response);
                    break block26;
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this._errorPageManager != null) {
                    this._errorPageManager.sendServletError(e, request, response);
                    break block26;
                }
                throw e;
            }
            finally {
                if (request instanceof AbstractHttpRequest) {
                    ((AbstractHttpRequest)request).finishInvocation();
                }
                if (this._tm != null) {
                    try {
                        TransactionImpl transaction = this._tm.getCurrent();
                        if (transaction.getStatus() != 6) {
                            log.warning("Transaction not properly closed for " + ((HttpServletRequest)request).getRequestURL());
                        }
                        transaction.close();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if (response instanceof AbstractHttpResponse) {
                    ((AbstractHttpResponse)response).finishInvocation();
                }
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

