/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.VersionFactory;
import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.management.server.ConnectionPoolMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ProxyCacheMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.management.server.ServerMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.management.server.ThreadPoolMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResinStatusServlet
extends GenericServlet {
    protected static final Logger log = Logger.getLogger(ResinStatusServlet.class.getName());
    static final L10N L = new L10N(ResinStatusServlet.class);
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private String _enable;
    private MBeanServer _mbeanServer;
    private ResinMXBean _resin;
    private ServerMXBean _server;
    private ClusterMXBean _cluster;
    private ProxyCacheMXBean _proxyCache;

    public void setEnable(String enable) throws ConfigException {
        if (!"read".equals(enable) && !"write".equals(enable)) {
            throw new ConfigException(L.l("enable value '{0}' must either be read or write.", (Object)enable));
        }
        this._enable = enable;
    }

    public void init() throws ServletException {
        if (this._enable == null) {
            throw new ServletException(L.l("ResinStatusServlet requires an explicit enable attribute."));
        }
        try {
            this._mbeanServer = Jmx.getGlobalMBeanServer();
            this._resin = (ResinMXBean)Jmx.findGlobal("resin:type=Resin");
            this._server = (ServerMXBean)Jmx.findGlobal("resin:type=Server");
            this._cluster = (ClusterMXBean)Jmx.findGlobal("resin:type=Cluster");
            this._proxyCache = (ProxyCacheMXBean)Jmx.findGlobal("resin:type=ProxyCache");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            res.setContentType("text/html");
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            PrintWriter out = res.getWriter();
            this.printHeader(out);
            String hostName = req.getParameter("host");
            String appName = req.getParameter("app");
            this.printServerHeader(out);
            this.printPorts(out);
            this.printSrun(out);
            this.printApplicationSummary(out, req.getRequestURI());
            this.printFooter(out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printHeader(PrintWriter out) throws IOException, ServletException {
    }

    public void printServerHeader(PrintWriter out) throws Exception {
        String configFile;
        out.println("<b>resin-status</b><br><br>");
        String id = this._server.getId();
        out.println("<table border=\"0\">");
        if (id != null) {
            out.println("<tr><td><b>Server:</b><td>" + id);
        }
        if ((configFile = this._resin.getConfigFile()) != null) {
            out.println("<tr><td><b>Config:</b><td>" + configFile);
        }
        long startTime = this._server.getStartTime().getTime();
        out.println("<tr><td><b>Server Start:</b><td> " + QDate.formatLocal(startTime));
        long totalMemory = this._server.getRuntimeMemory();
        out.println("<tr><td><b>Total Memory:</b><td> " + totalMemory / 1000000L + "." + totalMemory / 100000L % 10L + totalMemory / 10000L % 10L + "Meg");
        long freeMemory = this._server.getRuntimeMemoryFree();
        out.println("<tr><td><b>Free Memory:</b><td> " + freeMemory / 1000000L + "." + freeMemory / 100000L % 10L + freeMemory / 10000L % 10L + "Meg");
        long invocationHitCount = this._server.getInvocationCacheHitCountTotal();
        long invocationMissCount = this._server.getInvocationCacheMissCountTotal();
        long totalCount = invocationHitCount + invocationMissCount;
        if (totalCount == 0L) {
            totalCount = 1L;
        }
        long hitRatio = 10000L * invocationHitCount / totalCount;
        out.print("<tr><td><b>Invocation Hit Ratio:</b><td> " + hitRatio / 100L + "." + hitRatio / 10L % 10L + hitRatio % 10L + "%");
        out.println(" (" + invocationHitCount + "/" + totalCount + ")");
        if (this._proxyCache != null) {
            long proxyMissCount;
            long proxyHitCount = this._proxyCache.getHitCountTotal();
            totalCount = proxyHitCount + (proxyMissCount = this._proxyCache.getMissCountTotal());
            if (totalCount == 0L) {
                totalCount = 1L;
            }
            hitRatio = 10000L * proxyHitCount / totalCount;
            out.print("<tr><td><b>Proxy Cache Hit Ratio:</b><td> " + hitRatio / 100L + "." + hitRatio / 10L % 10L + hitRatio % 10L + "%");
            out.println(" (" + proxyHitCount + "/" + totalCount + ")");
        }
        out.println("</table>");
        this.printThreadHeader(out);
        this.printConnectionPools(out, "");
    }

    public void printThreadHeader(PrintWriter out) throws Exception {
        out.println("<table border='3'>");
        ThreadPoolMXBean threadPool = (ThreadPoolMXBean)Jmx.findGlobal("resin:type=ThreadPool");
        out.println("<tr><th colspan='3'>Threads");
        out.println("    <th colspan='3'>Config");
        out.println("<tr><th>Active<th>Idle<th>Total");
        out.println("    <th>thread-max<th>thread-idle-min");
        out.println("<tr align='right'>");
        out.println("    <td>" + threadPool.getThreadActiveCount());
        out.println("    <td>" + threadPool.getThreadIdleCount());
        out.println("    <td>" + threadPool.getThreadCount());
        out.println("    <td>" + threadPool.getThreadMax());
        out.println("    <td>" + threadPool.getThreadIdleMin());
        out.println("</table>");
    }

    public void printPorts(PrintWriter out) throws IOException, ServletException {
        try {
            PortMXBean[] portList = this._server.getPorts();
            if (portList.length > 0) {
                out.println("<h3>TCP ports</h3>");
                out.println("<table border='2'>");
                out.println("<tr><th><th colspan='3'>Threads<th>&nbsp;");
                out.println("<tr><th>Protocol:Port");
                out.println("    <th>Active<th>Idle<th>Total");
                out.println("    <th>Keepalive<th>Select");
                for (int i = 0; i < portList.length; ++i) {
                    PortMXBean port = portList[i];
                    if (port == null || !"active".equals(port.getState())) continue;
                    String host = port.getAddress();
                    if (host == null) {
                        host = "*";
                    }
                    out.print("<tr><td>");
                    out.print(port.getProtocolName() + "://" + host + ":" + port.getPort());
                    out.println();
                    out.print("    <td>" + port.getThreadActiveCount());
                    out.print("<td>" + port.getThreadIdleCount());
                    out.print("<td>" + port.getThreadActiveCount());
                    out.print("<td>" + port.getKeepaliveThreadCount());
                    out.print("<td>" + port.getKeepaliveSelectCount());
                    out.println();
                    out.println();
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printSrun(PrintWriter out) throws IOException, ServletException {
        try {
            String[] clusterList = new String[]{};
            for (int i = 0; i < clusterList.length; ++i) {
                ClusterMXBean cluster = (ClusterMXBean)Jmx.findGlobal(clusterList[i]);
                if (cluster == null) {
                    out.println("<h3>Cluster " + clusterList[i] + " null</h3>");
                    continue;
                }
                ObjectName objectName = cluster.getObjectName();
                String clusterName = objectName.getKeyProperty("name");
                out.println("<h3>Cluster " + clusterName + "</h3>");
                out.println("<table border='2'>");
                out.println("<tr><th>Host");
                out.println("    <th>Active");
                ClusterServerMXBean[] servers = cluster.getServers();
                for (int j = 0; j < servers.length; ++j) {
                    ClusterServerMXBean client = servers[j];
                    String host = client.getAddress();
                    String port = String.valueOf(client.getPort());
                    out.println("<tr>");
                    boolean canConnect = client.ping();
                    if (canConnect) {
                        out.print("<td bgcolor='#80ff80'>");
                    } else {
                        out.print("<td>");
                    }
                    out.print(host + ":" + port);
                    if (canConnect) {
                        out.println(" (up)");
                    } else {
                        out.println(" (down)");
                    }
                    out.println("<td>" + client.getConnectionActiveCount());
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printConnectionPools(PrintWriter out, String context) throws Exception {
        ObjectName pattern = new ObjectName("resin:*,type=ConnectionPool" + context);
        Set<ObjectName> poolNames = this._mbeanServer.queryNames(pattern, null);
        if (poolNames.size() == 0) {
            return;
        }
        out.println("<h3>Connection Pools</h3>");
        out.println("<table border='2'>");
        out.println("<tr><th>&nbsp;<th colspan='3'>Connections<th colspan='2'>Config");
        out.println("<tr><th>Name<th>Active<th>Idle<th>Total");
        out.println("    <th>max-connections<th>idle-time");
        for (ObjectName name : poolNames) {
            ConnectionPoolMXBean pool = (ConnectionPoolMXBean)Jmx.findGlobal(name);
            if (pool == null) continue;
            out.println("<tr><td>" + pool.getName());
            out.println("    <td>" + pool.getConnectionActiveCount());
            out.println("    <td>" + pool.getConnectionIdleCount());
            out.println("    <td>" + pool.getConnectionCount());
            out.println("    <td>" + pool.getMaxConnections());
            out.println("    <td>" + this.periodToString(pool.getMaxIdleTime()));
        }
        out.println("</table>");
    }

    private String periodToString(long time) {
        if (time == 0L) {
            return "0s";
        }
        if (time % 86400000L == 0L) {
            return time / 86400000L + "d";
        }
        if (time % 3600000L == 0L) {
            return time / 3600000L + "h";
        }
        if (time % 60000L == 0L) {
            return time / 60000L + "min";
        }
        if (time % 1000L == 0L) {
            return time / 1000L + "s";
        }
        return time + "ms";
    }

    public void printApplicationSummary(PrintWriter out, String pwd) throws Exception {
        HostMXBean host;
        out.println("<h3>Hosts and Applications</h3>");
        out.println("<table border=\"2\">");
        out.println("<tr><th>Host<th>Web-App<th>State<th>Sessions");
        ObjectName hostPattern = new ObjectName("resin:*,type=Host");
        Set<ObjectName> names = this._mbeanServer.queryNames(hostPattern, null);
        Iterator<ObjectName> iter = names.iterator();
        ArrayList<HostMXBean> hosts = new ArrayList<HostMXBean>();
        while (iter.hasNext()) {
            ObjectName name = iter.next();
            if ("current".equals(name.getKeyProperty("name")) || (host = (HostMXBean)Jmx.findGlobal(name)) == null) continue;
            hosts.add(host);
        }
        Collections.sort(hosts, new HostCompare());
        for (int i = 0; i < hosts.size(); ++i) {
            host = (HostMXBean)hosts.get(i);
            out.println("<tr><td><b>" + host.getURL() + "</b>");
            String hostName = host.getHostName();
            if (hostName.equals("")) {
                hostName = "default";
            }
            ObjectName appPattern = new ObjectName("resin:*,Host=" + hostName + ",type=WebApp");
            names = this._mbeanServer.queryNames(appPattern, null);
            iter = names.iterator();
            ArrayList<WebAppMXBean> apps = new ArrayList<WebAppMXBean>();
            while (iter.hasNext()) {
                ObjectName name = iter.next();
                try {
                    WebAppMXBean app = (WebAppMXBean)Jmx.findGlobal(name);
                    if (app == null) continue;
                    apps.add(app);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString());
                    out.println("<tr><td>" + name + "<td>" + e.toString());
                }
            }
            Collections.sort(apps, new AppCompare());
            for (int j = 0; j < apps.size(); ++j) {
                WebAppMXBean webApp = (WebAppMXBean)apps.get(j);
                SessionManagerMXBean session = webApp.getSessionManager();
                String contextPath = webApp.getContextPath();
                if (contextPath.equals("")) {
                    contextPath = "/";
                }
                out.print("<tr><td><td>");
                out.print("<a href=\"" + pwd + "?host=" + host.getHostName() + "&app=" + webApp.getContextPath() + "\">");
                out.print(contextPath);
                out.print("</a>");
                String state = webApp.getState();
                if (state.equals("active")) {
                    out.print("<td bgcolor='#80ff80'>" + webApp.getState());
                } else {
                    out.print("<td>" + webApp.getState());
                }
                if (session != null) {
                    out.print("<td>" + session.getSessionActiveCount());
                    continue;
                }
                out.print("<td>n/a");
            }
        }
        out.println("</table>");
    }

    public void printVirtualHosts(PrintWriter out) throws IOException, ServletException {
    }

    public void printFooter(PrintWriter out) throws IOException, ServletException {
        out.println("<br><em>" + VersionFactory.getFullVersion() + "</em>");
    }

    static class AppCompare
    implements Comparator<WebAppMXBean> {
        AppCompare() {
        }

        @Override
        public int compare(WebAppMXBean a, WebAppMXBean b) {
            String cpA = a.getContextPath();
            String cpB = b.getContextPath();
            return cpA.compareTo(cpB);
        }
    }

    static class HostCompare
    implements Comparator<HostMXBean> {
        HostCompare() {
        }

        @Override
        public int compare(HostMXBean a, HostMXBean b) {
            String urlB;
            String urlA = a.getURL();
            if (urlA == (urlB = b.getURL())) {
                return 0;
            }
            if (urlA == null) {
                return -1;
            }
            if (urlB == null) {
                return 1;
            }
            return urlA.compareTo(urlB);
        }
    }
}

