/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class ConnectionConfig {
    private static final L10N L = new L10N(ConnectionConfig.class);
    private int _isolation = -1;
    private boolean _readOnly;
    private String _catalog;

    public void setTransactionIsolation(String name) throws ConfigException {
        if ("none".equals(name)) {
            this._isolation = 0;
        } else if ("read-committed".equals(name)) {
            this._isolation = 2;
        } else if ("read-uncommitted".equals(name)) {
            this._isolation = 1;
        } else if ("repeatable-read".equals(name)) {
            this._isolation = 4;
        } else if ("serializable".equals(name)) {
            this._isolation = 8;
        } else if (name != null && name.length() > 0 && Character.isDigit(name.charAt(0))) {
            this._isolation = Integer.parseInt(name);
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown transaction isolation.", (Object)name));
        }
    }

    public int getTransactionIsolation() {
        return this._isolation;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._readOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setCatalog(String catalog) {
        this._catalog = !"".equals(catalog) ? catalog : null;
    }

    public String getCatalog() {
        return this._catalog;
    }
}

