/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

public class BasicFuture<V>
implements Future<V> {
    private volatile V _value;
    private volatile boolean _isDone;
    private volatile RuntimeException _exn;
    private volatile Thread _thread;

    @Override
    public boolean isDone() {
        return this._isDone;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Thread thread = Thread.currentThread();
        try {
            this._thread = thread;
            long expires = System.currentTimeMillis() + unit.toMillis(timeout);
            do {
                if (this._isDone) {
                    if (this._exn != null) {
                        throw this._exn;
                    }
                    V v = this._value;
                    return v;
                }
                Thread.interrupted();
                LockSupport.parkUntil(expires);
            } while (System.currentTimeMillis() < expires);
            throw new TimeoutException(this.toString() + ": " + timeout + " " + (Object)((Object)unit));
        }
        finally {
            this._thread = null;
        }
    }

    public void complete(V value) {
        this._value = value;
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public void complete(RuntimeException exn) {
        this._exn = exn;
        this._isDone = true;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public boolean cancel(boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

