/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashMapImpl<K, V>
extends AbstractMap<K, V> {
    private K[] _keys;
    private V[] _values;
    private V _nullValue;
    private int _capacity;
    private int _size;
    private int _mask;

    public HashMapImpl() {
        this(16);
    }

    public HashMapImpl(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._keys = new Object[capacity];
        this._values = new Object[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void clear() {
        if (this._size > 0) {
            K[] keys = this._keys;
            V[] values = this._values;
            int length = values.length;
            for (int i = length - 1; i >= 0; --i) {
                keys[i] = null;
                values[i] = null;
            }
            this._size = 0;
        }
        this._nullValue = null;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this._nullValue;
        }
        int hash = key.hashCode() & this._mask;
        K[] keys = this._keys;
        for (int count = this._size + 1; count > 0; --count) {
            K mapKey = keys[hash];
            if (mapKey == null) {
                return null;
            }
            if (key.equals(this._keys[hash])) {
                return this._values[hash];
            }
            hash = hash + 1 & this._mask;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            V item = this._nullValue;
            this._nullValue = value;
            return item;
        }
        if (this._values.length <= 2 * this._size) {
            K[] oldKeys = this._keys;
            V[] oldValues = this._values;
            this._keys = new Object[2 * oldKeys.length];
            this._values = new Object[2 * oldValues.length];
            this._mask = this._values.length - 1;
            this._size = 0;
            for (int i = oldValues.length - 1; i >= 0; --i) {
                K oldKey = oldKeys[i];
                V oldValue = oldValues[i];
                if (oldValue == null) continue;
                this.putImpl(oldKey, oldValue);
            }
        }
        V item = this.putImpl(key, value);
        return item;
    }

    private V putImpl(K key, V value) {
        V item = null;
        int hash = key.hashCode() & this._mask;
        for (int count = this._values.length; count > 0; --count) {
            item = this._values[hash];
            if (item == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                ++this._size;
                return null;
            }
            if (this._keys[hash].equals(key)) {
                this._values[hash] = value;
                return item;
            }
            hash = hash + 1 & this._mask;
        }
        throw new IllegalStateException();
    }

    @Override
    public V remove(Object key) {
        int count;
        if (key == null) {
            V value = this._nullValue;
            this._nullValue = null;
            return value;
        }
        int hash = key.hashCode() & this._mask;
        V item = null;
        for (count = this._size + 1; count > 0; --count) {
            item = this._values[hash];
            if (item == null) {
                return null;
            }
            if (this._keys[hash].equals(key)) {
                this._keys[hash] = null;
                this._values[hash] = null;
                --this._size;
                this.refillEntries(hash);
                break;
            }
            hash = hash + 1 & this._mask;
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        return item;
    }

    private void refillEntries(int hash) {
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash = hash + 1 & this._mask] == null) {
                return;
            }
            this.refillEntry(hash);
        }
    }

    private void refillEntry(int baseHash) {
        K key = this._keys[baseHash];
        V value = this._values[baseHash];
        this._keys[baseHash] = null;
        this._values[baseHash] = null;
        int hash = key.hashCode() & this._mask;
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash] == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                return;
            }
            hash = hash + 1 & this._mask;
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySet(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this);
    }

    static class Entry<K1, V1>
    implements Map.Entry<K1, V1> {
        private HashMapImpl<K1, V1> _map;
        private int _i;

        Entry() {
        }

        void init(HashMapImpl<K1, V1> map, int i) {
            this._map = map;
            this._i = i;
        }

        @Override
        public K1 getKey() {
            return (K1)((HashMapImpl)this._map)._keys[this._i];
        }

        @Override
        public V1 getValue() {
            return (V1)((HashMapImpl)this._map)._values[this._i];
        }

        @Override
        public V1 setValue(V1 value) {
            Object oldValue = ((HashMapImpl)this._map)._values[this._i];
            ((HashMapImpl)this._map)._values[this._i] = value;
            return (V1)oldValue;
        }
    }

    static class EntryIterator<K1, V1>
    implements Iterator<Map.Entry<K1, V1>> {
        private final Entry<K1, V1> _entry = new Entry();
        private HashMapImpl<K1, V1> _map;
        private int _i;

        EntryIterator(HashMapImpl<K1, V1> map) {
            this.init(map);
        }

        void init(HashMapImpl<K1, V1> map) {
            this._map = map;
            this._i = 0;
        }

        @Override
        public boolean hasNext() {
            Object[] keys = ((HashMapImpl)this._map)._keys;
            int len = keys.length;
            while (this._i < len) {
                if (keys[this._i] != null) {
                    return true;
                }
                ++this._i;
            }
            return false;
        }

        @Override
        public Map.Entry<K1, V1> next() {
            Object[] keys = ((HashMapImpl)this._map)._keys;
            int len = keys.length;
            while (this._i < len) {
                if (keys[this._i] != null) {
                    this._entry.init(this._map, this._i++);
                    return this._entry;
                }
                ++this._i;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this._i > 0) {
                this._map.remove(((HashMapImpl)this._map)._keys[this._i - 1]);
            }
        }
    }

    static class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private HashMapImpl<K1, V1> _map;

        EntrySet(HashMapImpl<K1, V1> map) {
            this._map = map;
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            return new EntryIterator<K1, V1>(this._map);
        }
    }

    static class KeyIterator<K1, V1>
    implements Iterator<K1> {
        private HashMapImpl<K1, V1> _map;
        private int _i;

        KeyIterator(HashMapImpl<K1, V1> map) {
            this.init(map);
        }

        void init(HashMapImpl<K1, V1> map) {
            this._map = map;
            this._i = 0;
        }

        @Override
        public boolean hasNext() {
            Object[] keys = ((HashMapImpl)this._map)._keys;
            int len = keys.length;
            while (this._i < len) {
                if (keys[this._i] != null) {
                    return true;
                }
                ++this._i;
            }
            return false;
        }

        @Override
        public K1 next() {
            Object[] keys = ((HashMapImpl)this._map)._keys;
            int len = keys.length;
            while (this._i < len) {
                Object key = keys[this._i];
                if (key != null) {
                    ++this._i;
                    return (K1)key;
                }
                ++this._i;
            }
            return null;
        }

        @Override
        public void remove() {
            if (this._i > 0) {
                this._map.remove(((HashMapImpl)this._map)._keys[this._i - 1]);
            }
        }
    }

    static class KeySet<K1, V1>
    extends AbstractSet<K1> {
        private HashMapImpl<K1, V1> _map;

        KeySet(HashMapImpl<K1, V1> map) {
            this._map = map;
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public boolean contains(Object key) {
            if (key == null) {
                return ((HashMapImpl)this._map)._nullValue != null;
            }
            Object[] keys = ((HashMapImpl)this._map)._keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object testKey = keys[i];
                if (!key.equals(testKey)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> keys) {
            if (keys == null) {
                return false;
            }
            for (Object key : keys) {
                this._map.remove(key);
            }
            return true;
        }

        @Override
        public Iterator<K1> iterator() {
            return new KeyIterator<K1, V1>(this._map);
        }
    }
}

