/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharCursor;

public class StringCharCursor
extends CharCursor {
    private CharSequence _string;
    private int _length;
    private int _pos;

    public StringCharCursor(CharSequence string) {
        this._string = string;
        this._length = string.length();
        this._pos = 0;
    }

    public StringCharCursor(CharSequence string, int offset) {
        this._string = string;
        this._length = string.length();
        this._pos = offset;
    }

    @Override
    public int getIndex() {
        return this._pos;
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this._length;
    }

    @Override
    public char setIndex(int pos) {
        if (pos < 0) {
            this._pos = 0;
            return '\uffff';
        }
        if (this._length <= pos) {
            this._pos = this._length;
            return '\uffff';
        }
        this._pos = pos;
        return this._string.charAt(pos);
    }

    @Override
    public char next() {
        if (this._length <= ++this._pos) {
            this._pos = this._length;
            return '\uffff';
        }
        return this._string.charAt(this._pos);
    }

    @Override
    public char previous() {
        if (--this._pos < 0) {
            this._pos = 0;
            return '\uffff';
        }
        return this._string.charAt(this._pos);
    }

    @Override
    public char current() {
        if (this._length <= this._pos) {
            return '\uffff';
        }
        return this._string.charAt(this._pos);
    }

    @Override
    public char skip(int n) {
        this._pos += n;
        if (this._length <= this._pos) {
            this._pos = this._string.length();
            return '\uffff';
        }
        return this._string.charAt(this._pos);
    }

    public void init(CharSequence string) {
        this._string = string;
        this._length = string.length();
        this._pos = 0;
    }

    @Override
    public Object clone() {
        return new StringCharCursor(this._string);
    }
}

