/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.DatastoreInputStream;
import com.caucho.vfs.DatastorePath;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class DatastoreReadStream
extends StreamImpl
implements LockableStream {
    private static final Logger log = Logger.getLogger(DatastoreReadStream.class.getName());
    private DatastoreInputStream _is;

    public DatastoreReadStream() {
    }

    public DatastoreReadStream(DatastoreInputStream is) {
        this.init(is);
    }

    public DatastoreReadStream(DatastoreInputStream is, DatastorePath path) {
        this.init(is);
        this.setPath(path);
    }

    public void init(DatastoreInputStream is) {
        this._is = is;
        this.setPath(null);
    }

    @Override
    public boolean hasSkip() {
        return this._is != null;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this._is != null) {
            return this._is.skip(n);
        }
        return -1L;
    }

    @Override
    public void seekStart(long offset) throws IOException {
        if (this._is != null) {
            this._is.setPosition(offset);
        }
    }

    @Override
    public boolean canRead() {
        return this._is != null;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._is == null) {
            return -1;
        }
        int len = this._is.read(buf, offset, length);
        return len;
    }

    @Override
    public int getAvailable() throws IOException {
        if (this._is == null) {
            return -1;
        }
        return this._is.available();
    }

    @Override
    public void close() throws IOException {
        this.unlock();
        DatastoreInputStream is = this._is;
        this._is = null;
        if (is != null) {
            ((InputStream)is).close();
        }
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        return true;
    }

    @Override
    public boolean unlock() {
        return true;
    }
}

