/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceNode
extends QAbstractNode
implements CauchoNode {
    Node _parent;
    NamespaceNode _next;
    NamespaceNode _prev;
    String _local;
    String _name;
    String _url;

    public NamespaceNode(Node parent, NamespaceNode next, String prefix, String url) {
        this._parent = parent;
        this._next = next;
        if (next != null) {
            next._prev = this;
        }
        this._local = prefix;
        this._name = prefix == null || prefix.equals("") ? "xmlns" : ("xmlns:" + prefix).intern();
        this._url = url;
    }

    static NamespaceNode create(Node node) {
        Node top = node;
        NamespaceNode nodes = null;
        HashMap<String, String> map = new HashMap<String, String>();
        while (node instanceof CauchoElement) {
            CauchoElement elt = (CauchoElement)node;
            String prefix = elt.getPrefix();
            String url = elt.getNamespaceURI();
            if (url == null) {
                url = "";
            }
            if (map.get(prefix) == null) {
                map.put(prefix, url);
                if (!url.equals("")) {
                    nodes = new NamespaceNode(top, nodes, prefix, url);
                }
            }
            for (QAttr attr = (QAttr)elt.getFirstAttribute(); attr != null; attr = (QAttr)attr.getNextSibling()) {
                String name = attr.getNodeName();
                prefix = null;
                url = "";
                if (name.startsWith("xmlns:")) {
                    prefix = name.substring(6);
                    url = attr.getNodeValue();
                } else if (name.equals("xmlns")) {
                    prefix = "";
                    url = attr.getNodeValue();
                } else {
                    prefix = attr.getPrefix();
                    url = attr.getNamespaceURI();
                }
                if (url == null) {
                    url = "";
                }
                if (map.get(prefix) != null) continue;
                map.put(prefix, url);
                if (url.equals("")) continue;
                nodes = new NamespaceNode(top, nodes, prefix, url);
            }
            node = node.getParentNode();
        }
        return nodes;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this._name;
    }

    @Override
    public String getPrefix() {
        return "xmlns";
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public boolean supports(String feature, String version) {
        return false;
    }

    @Override
    public String getCanonicalName() {
        return "";
    }

    @Override
    public String getLocalName() {
        return this._local;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getNodeValue() {
        return this._url;
    }

    @Override
    public Node getParentNode() {
        return this._parent;
    }

    @Override
    public Node getPreviousSibling() {
        return this._prev;
    }

    @Override
    public Node getNextSibling() {
        return this._next;
    }

    public void setLocation(String filename, int line, int column) {
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getColumn() {
        return 0;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public NodeList getChildNodes() {
        return null;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        return null;
    }

    @Override
    public Node replaceChild(Node newChild, Node refChild) {
        return null;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public Node appendChild(Node newNode) throws DOMException {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public String getTextValue() {
        return this.getNodeValue();
    }

    @Override
    public boolean checkValid() {
        return false;
    }

    @Override
    public void print(WriteStream out) throws IOException {
    }

    @Override
    public void printPretty(WriteStream out) throws IOException {
    }

    @Override
    public void printHtml(WriteStream out) throws IOException {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    public String toString() {
        return "NamespaceNode[" + this._name + " " + this._url + "]";
    }
}

