/*
 * Copyright (c) 1998-2018 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *
 *   Free Software Foundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.remote.websocket;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * WebSocketOutputStream writes a single WebSocket packet.
 *
 * <code><pre>
 * </pre></code>
 */
public class WebSocketPrintWriter extends PrintWriter
{
  private static final Logger log
    = Logger.getLogger(WebSocketPrintWriter.class.getName());
  private final WebSocketWriter _out;
  
  public WebSocketPrintWriter(WebSocketWriter out)
    throws IOException
  {
    super(out);
    
    _out = out;
  }

  @Override
  public void close()
  {
    // WebSocketPrintWriter is reused
    /*
    WebSocketWriter out = _out;
    _out = null;
    
    if (out != null) {
      out.close();
    }
    */

    try {
      _out.close();
    } catch (Exception e) {
      log.log(Level.FINE, e.toString(), e);
    }
  }
}
