/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.servlet;

import com.caucho.config.ConfigException;
import com.caucho.jmx.Jmx;
import com.caucho.jmx.MXAction;
import com.caucho.jmx.MXContentType;
import com.caucho.jmx.MXParam;
import com.caucho.json.JsonOutput;
import com.caucho.management.server.ManagementMXBean;
import com.caucho.management.server.StatServiceValue;
import com.caucho.server.admin.AddUserQueryReply;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.server.admin.JsonQueryReply;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.server.admin.ListUsersQueryReply;
import com.caucho.server.admin.PdfReportQueryReply;
import com.caucho.server.admin.RemoveUserQueryReply;
import com.caucho.server.admin.StatServiceValuesQueryReply;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.server.admin.UserQueryReply;
import com.caucho.server.deploy.DeployControllerState;
import com.caucho.server.deploy.DeployTagResult;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminRestServlet
extends HttpServlet {
    private static final L10N L = new L10N(AdminRestServlet.class);
    private static final Logger log = Logger.getLogger(AdminRestServlet.class.getName());
    private static final HashMap<Class<?>, Marshal> _marshalMap = new HashMap();
    private static final HashMap<String, Action> _actionMap = new HashMap();
    private boolean _isRequireSecure = true;

    public void setRequireSecure(boolean isSecure) {
        this._isRequireSecure = isSecure;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Principal user = req.getUserPrincipal();
        if (user == null) {
            res.setStatus(403);
            PrintWriter out = res.getWriter();
            out.println(L.l("admin requires a valid user"));
            return;
        }
        if (!req.isUserInRole("resin-admin")) {
            res.setStatus(403);
            PrintWriter out = res.getWriter();
            out.println(L.l("admin requires a user in the resin-admin role"));
            return;
        }
        if (this._isRequireSecure && !req.isSecure()) {
            res.setStatus(403);
            PrintWriter out = res.getWriter();
            out.println(L.l("admin requires a secure connection"));
            return;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null || "/".equals(pathInfo)) {
            res.setStatus(500);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            out.println(L.l("action is required"));
            return;
        }
        String actionName = pathInfo.substring(1);
        Action action = _actionMap.get(actionName);
        if (action == null) {
            res.setStatus(500);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            out.println(L.l("'{0}' is an unknown action", (Object)actionName));
            return;
        }
        if (!action.getHttpMethod().equals(req.getMethod())) {
            res.setStatus(500);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            out.println(L.l("http method {0} is expected", (Object)action.getHttpMethod()));
            return;
        }
        try {
            action.doAction(req, res);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            res.setStatus(500);
            PrintWriter out = res.getWriter();
            if (cause instanceof ConfigException) {
                out.println(cause.getMessage());
            }
            out.println(cause);
        }
    }

    private static void introspectManagementOperations() {
        Class<ManagementMXBean> cl = ManagementMXBean.class;
        for (Method method : cl.getDeclaredMethods()) {
            MXAction mxAction = method.getAnnotation(MXAction.class);
            if (mxAction == null) continue;
            String name = mxAction.value();
            String httpMethod = mxAction.method();
            Action action = new Action(method, httpMethod);
            _actionMap.put(name, action);
        }
    }

    static {
        _marshalMap.put(Void.TYPE, new VoidMarshal());
        _marshalMap.put(String.class, new StringMarshal());
        _marshalMap.put(Integer.class, new IntegerMarshal());
        _marshalMap.put(Long.class, new LongMarshal());
        _marshalMap.put(Boolean.TYPE, new BooleanMarshal());
        _marshalMap.put(InputStream.class, new InputStreamMarshal());
        _marshalMap.put(String[].class, new StringArrayMarshal());
        _marshalMap.put(InputStream.class, new InputStreamMarshal());
        _marshalMap.put(Date[].class, new DateArrayMarshal());
        _marshalMap.put(StringQueryReply.class, new StringQueryReplyMarshal());
        _marshalMap.put(JsonQueryReply.class, new JsonQueryReplyMarshal());
        _marshalMap.put(AddUserQueryReply.class, new AddUserQueryReplyMarshal());
        _marshalMap.put(DeployTagResult[].class, new TagReplyMarshal());
        _marshalMap.put(StatServiceValuesQueryReply.class, new StatServiceValuesQueryReplytMarshal());
        _marshalMap.put(RemoveUserQueryReply.class, new RemoveUserQueryReplyMarshal());
        _marshalMap.put(ListUsersQueryReply.class, new ListUsersQueryResultMarshal());
        _marshalMap.put(ListJmxQueryReply.class, new ListJmxQueryReplyMarshal());
        _marshalMap.put(JmxSetQueryReply.class, new JmxSetQueryReplyMarshal());
        _marshalMap.put(JmxCallQueryReply.class, new JmxCallQueryReplyMarshal());
        _marshalMap.put(DeployControllerState.class, new ControllerStateActionQueryReplyMarshal());
        _marshalMap.put(PdfReportQueryReply.class, new PdfReportQueryReplyMarshal());
        AdminRestServlet.introspectManagementOperations();
    }

    static class StatServiceValuesQueryReplytMarshal
    extends Marshal<StatServiceValuesQueryReply> {
        StatServiceValuesQueryReplytMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, StatServiceValuesQueryReply defaultValue) throws IOException {
            return null;
        }

        @Override
        public void unmarshal(HttpServletResponse response, StatServiceValuesQueryReply stats) throws IOException {
            PrintWriter out = response.getWriter();
            String[] names = stats.getNames();
            StatServiceValue[][] data = stats.getData();
            out.println("[");
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                StatServiceValue[] values = data[i];
                out.println("  {");
                out.print("    \"label\":");
                out.print('\"' + name + '\"');
                out.println(',');
                out.println("    \"data\": [");
                for (int j = 0; j < values.length; ++j) {
                    StatServiceValue value = values[j];
                    out.print("              [" + value.getTime() + "," + value.getValue() + "]");
                    if (j + 1 < values.length) {
                        out.print(",");
                    }
                    out.println();
                }
                out.println("            ]");
                out.print("  }");
                if (i + 1 < names.length) {
                    out.print(",");
                }
                out.println();
            }
            out.println("]");
        }
    }

    static class JmxCallQueryReplyMarshal
    extends Marshal<JmxCallQueryReply> {
        JmxCallQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, JmxCallQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }

        @Override
        public void unmarshal(HttpServletResponse response, JmxCallQueryReply value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value, true);
            out.flush();
        }
    }

    static class JmxSetQueryReplyMarshal
    extends Marshal<JmxSetQueryReply> {
        JmxSetQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, JmxSetQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }

        @Override
        public void unmarshal(HttpServletResponse response, JmxSetQueryReply value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value, true);
            out.flush();
        }
    }

    static class ListJmxQueryReplyMarshal
    extends Marshal<ListJmxQueryReply> {
        ListJmxQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, ListJmxQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }

        @Override
        public void unmarshal(HttpServletResponse response, ListJmxQueryReply value) throws IOException {
            PrintWriter writer = response.getWriter();
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject((Serializable)((Object)value.getBeans()), true);
            out.flush();
            writer.flush();
        }
    }

    static class DateArrayMarshal
    extends Marshal<Date[]> {
        DateArrayMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, Date[] value) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }
    }

    static class StringArrayMarshal
    extends Marshal<String[]> {
        StringArrayMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, String[] value) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }
    }

    static class TagReplyMarshal
    extends Marshal<DeployTagResult[]> {
        TagReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, DeployTagResult[] defaultValue) throws IOException {
            throw new AbstractMethodError(this.getClass().getName());
        }

        @Override
        public void unmarshal(HttpServletResponse response, DeployTagResult[] value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value, true);
            out.flush();
        }
    }

    static class PdfReportQueryReplyMarshal
    extends Marshal<PdfReportQueryReply> {
        PdfReportQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, PdfReportQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, PdfReportQueryReply value) throws IOException {
            if (value.getPdf() != null) {
                response.setContentType("application/pdf");
                WriteStream out = Vfs.openWrite((OutputStream)response.getOutputStream());
                out.writeStream(value.getPdf().getInputStream());
                out.flush();
            } else {
                JsonOutput out = new JsonOutput(response.getWriter());
                out.writeObject(value.getFileName());
                out.flush();
            }
        }
    }

    static class ListUsersQueryResultMarshal
    extends Marshal<ListUsersQueryReply> {
        ListUsersQueryResultMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, ListUsersQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, ListUsersQueryReply value) throws IOException {
            UserQueryReply.User[] users = value.getUsers();
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(users);
            out.flush();
        }
    }

    static class RemoveUserQueryReplyMarshal
    extends Marshal<RemoveUserQueryReply> {
        RemoveUserQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, RemoveUserQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, RemoveUserQueryReply value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value.getUser(), true);
            out.flush();
        }
    }

    static class AddUserQueryReplyMarshal
    extends Marshal<AddUserQueryReply> {
        AddUserQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, AddUserQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, AddUserQueryReply value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value.getUser(), true);
            out.flush();
        }
    }

    static class ControllerStateActionQueryReplyMarshal
    extends Marshal<DeployControllerState> {
        ControllerStateActionQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, DeployControllerState defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, DeployControllerState value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject(value, true);
            out.flush();
        }
    }

    static class JsonQueryReplyMarshal
    extends Marshal<JsonQueryReply> {
        JsonQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, JsonQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, JsonQueryReply value) throws IOException {
            PrintWriter out = response.getWriter();
            out.write(value.getValue());
        }
    }

    static class StringQueryReplyMarshal
    extends Marshal<StringQueryReply> {
        StringQueryReplyMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, StringQueryReply defaultValue) throws IOException {
            throw new AbstractMethodError();
        }

        @Override
        public void unmarshal(HttpServletResponse response, StringQueryReply value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeString(value.getValue());
            out.flush();
        }
    }

    static class InputStreamMarshal
    extends Marshal<InputStream> {
        InputStreamMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, InputStream defaultValue) throws IOException {
            return request.getInputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unmarshal(HttpServletResponse response, InputStream value) throws IOException {
            ServletOutputStream os = response.getOutputStream();
            try (WriteStream out = Vfs.openWrite((OutputStream)os);){
                out.writeStream(value);
            }
        }
    }

    static class VoidMarshal
    extends Marshal<Void> {
        VoidMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, Void defaultValue) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    static class LongMarshal
    extends Marshal<Long> {
        LongMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, Long defaultValue) {
            String param = request.getParameter(name);
            if (param != null) {
                return Long.parseLong(param);
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            return 0;
        }
    }

    static class IntegerMarshal
    extends Marshal<Integer> {
        IntegerMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, Integer defaultValue) {
            String param = request.getParameter(name);
            if (param != null) {
                return Integer.parseInt(param);
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            return 0;
        }
    }

    static class StringMarshal
    extends Marshal<String> {
        StringMarshal() {
        }

        @Override
        public Object marshal(HttpServletRequest request, String name, String defaultValue) {
            String param = request.getParameter(name);
            if (param != null) {
                return param;
            }
            return defaultValue;
        }
    }

    static class BooleanMarshal
    extends Marshal<Boolean> {
        BooleanMarshal() {
        }

        public Boolean marshal(HttpServletRequest request, String name, Boolean defaultValue) {
            String param = request.getParameter(name);
            if (param != null) {
                return Boolean.parseBoolean(param);
            }
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.FALSE;
        }
    }

    static abstract class Marshal<K> {
        Marshal() {
        }

        public abstract Object marshal(HttpServletRequest var1, String var2, K var3) throws IOException;

        public void unmarshal(HttpServletResponse response, K value) throws IOException {
            JsonOutput out = new JsonOutput(response.getWriter());
            out.writeObject((Serializable)value);
            out.flush();
        }
    }

    static class Action {
        private Method _method;
        private String _httpMethod;
        private String[] _parameterNames;
        private Serializable[] _parameterDefaults;
        private boolean[] _parameterRequired;
        private Marshal[] _parameterMarshal;
        private Marshal _returnMarshal;
        private boolean _isPutStream;
        private boolean _isGetStream;
        private String _contentType;

        Action(Method method, String httpMethod) {
            int i;
            this._method = method;
            this._httpMethod = httpMethod;
            MXContentType contentType = method.getAnnotation(MXContentType.class);
            if (contentType != null) {
                this._contentType = contentType.value();
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            this._parameterNames = new String[parameterTypes.length];
            this._parameterDefaults = new Serializable[parameterTypes.length];
            this._parameterRequired = new boolean[parameterTypes.length];
            Annotation[][] paramAnn = method.getParameterAnnotations();
            for (i = 0; i < this._parameterNames.length; ++i) {
                MXParam mxParam = null;
                for (Annotation a : paramAnn[i]) {
                    if (!a.annotationType().equals(MXParam.class)) continue;
                    mxParam = (MXParam)a;
                    break;
                }
                if (mxParam == null) {
                    this._parameterNames[i] = "p" + i;
                    this._parameterDefaults[i] = null;
                    this._parameterRequired[i] = false;
                    continue;
                }
                this._parameterNames[i] = mxParam.name();
                this._parameterRequired[i] = mxParam.required();
                String defaultValue = mxParam.defaultValue();
                defaultValue = "[null]".equals(defaultValue) ? null : defaultValue;
                this._parameterDefaults[i] = Action.toValue(parameterTypes[i], defaultValue);
            }
            this._parameterMarshal = new Marshal[parameterTypes.length];
            for (i = 0; i < parameterTypes.length; ++i) {
                Marshal marshal = (Marshal)_marshalMap.get(parameterTypes[i]);
                if (marshal == null) {
                    throw new IllegalStateException(method + " has unknown marshal type");
                }
                this._parameterMarshal[i] = marshal;
            }
            this._returnMarshal = (Marshal)_marshalMap.get(method.getReturnType());
            if (this._returnMarshal == null) {
                throw new IllegalStateException(method + " has unknown return type");
            }
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1] == InputStream.class) {
                this._isPutStream = true;
            }
            if (InputStream.class.equals(method.getReturnType())) {
                this._isGetStream = true;
            }
        }

        String[] getParameterNames() {
            return this._parameterNames;
        }

        public String getHttpMethod() {
            return this._httpMethod;
        }

        void doAction(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
            ManagementMXBean management;
            try {
                management = (ManagementMXBean)Jmx.find("resin:type=Management");
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            Object[] params = new Object[this._parameterMarshal.length];
            for (int i = 0; i < params.length; ++i) {
                String requestParam = req.getParameter(this._parameterNames[i]);
                if (requestParam == null && this._parameterRequired[i]) {
                    res.setStatus(500);
                    res.setContentType("text/plain");
                    PrintWriter out = res.getWriter();
                    out.println(L.l("parameter `{0}' is requried.", (Object)this._parameterNames[i]));
                    return;
                }
                params[i] = this._parameterMarshal[i].marshal(req, this._parameterNames[i], this._parameterDefaults[i]);
            }
            try {
                Object value = this._method.invoke((Object)management, params);
                if (this._contentType != null) {
                    res.setContentType(this._contentType);
                }
                this._returnMarshal.unmarshal(res, value);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }

        protected static Serializable toValue(Class type, String value) {
            if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
                return Boolean.valueOf(Boolean.parseBoolean(value));
            }
            if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
                return Byte.valueOf(Byte.parseByte(value));
            }
            if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
                return Short.valueOf(Short.parseShort(value));
            }
            if (Character.TYPE.equals(type) || Character.class.equals((Object)type)) {
                return new Character((char)Integer.parseInt(value));
            }
            if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                return Integer.valueOf(Integer.parseInt(value));
            }
            if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
                return Long.valueOf(Long.parseLong(value));
            }
            if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                return Double.valueOf(Double.parseDouble(value));
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, value);
            }
            return value;
        }
    }
}

