/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.thread;

import com.caucho.admin.thread.AbstractThreadActivityReport;
import com.caucho.admin.thread.ThreadActivityCode;
import com.caucho.admin.thread.ThreadActivityGroup;
import com.caucho.admin.thread.ThreadSnapshot;
import com.caucho.admin.thread.filter.IdlePoolFilter;
import com.caucho.admin.thread.filter.ThreadSnapshotFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatabaseThreadActivityReport
extends AbstractThreadActivityReport {
    private final Map<ThreadSnapshotFilter, ThreadActivityCode> _codes = new LinkedHashMap<ThreadSnapshotFilter, ThreadActivityCode>();
    private Map<Character, String> _key = new HashMap<Character, String>();

    public DatabaseThreadActivityReport() {
        this._codes.put(new IdlePoolFilter(), ThreadActivityCode.IDLE);
        for (ThreadActivityCode code : ThreadActivityCode.values()) {
            this._key.put(Character.valueOf(code.getChar()), code.toString());
        }
        this._key = Collections.unmodifiableMap(this._key);
    }

    @Override
    public Map<Character, String> getScoreboardKey() {
        return this._key;
    }

    @Override
    protected boolean assignActivityCode(ThreadSnapshot thread) {
        for (Map.Entry<ThreadSnapshotFilter, ThreadActivityCode> entry : this._codes.entrySet()) {
            if (!entry.getKey().isMatch(thread)) continue;
            thread.setCode(entry.getValue().getChar());
            return true;
        }
        return false;
    }

    @Override
    protected ThreadActivityGroup[] createGroups() {
        ArrayList groups = new ArrayList();
        ThreadActivityGroup[] array = new ThreadActivityGroup[groups.size()];
        groups.toArray(array);
        return array;
    }
}

