/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.AmberFieldCompare;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.make.ClassDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class AmberBeanType
extends AbstractEnhancedType {
    private static final Logger log = Logger.getLogger(AmberBeanType.class.getName());
    private static final L10N L = new L10N(AmberBeanType.class);
    private boolean _isFieldAccess;
    private ArrayList<AmberField> _selfFields = new ArrayList();
    private volatile boolean _isConfigured;
    private ArrayList<PersistentDependency> _dependencies = new ArrayList();
    private HashMap<String, String> _completionFields = new HashMap();
    private AmberColumn _discriminator;

    public AmberBeanType(AmberPersistenceUnit amberPersistenceUnit) {
        super(amberPersistenceUnit);
    }

    public boolean isEntity() {
        return false;
    }

    public void setFieldAccess(boolean isFieldAccess) {
        this._isFieldAccess = isFieldAccess;
    }

    public boolean isFieldAccess() {
        return this._isFieldAccess;
    }

    public boolean isEmbeddable() {
        return false;
    }

    public AmberColumn getDiscriminator() {
        return this._discriminator;
    }

    public void setDiscriminator(AmberColumn discriminator) {
        this._discriminator = discriminator;
    }

    @Override
    public String getJavaTypeName() {
        return this.getInstanceClassName();
    }

    public void addField(AmberField field) {
        this._selfFields.add(field);
        Collections.sort(this._selfFields, new AmberFieldCompare());
    }

    public ArrayList<AmberField> getSelfFields() {
        return this._selfFields;
    }

    public ArrayList<AmberField> getFields() {
        return this._selfFields;
    }

    public AmberField getField(String name) {
        for (AmberField field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public void setBeanClass(Class beanClass) {
        super.setBeanClass(beanClass);
        this.addDependency(this._tBeanClass);
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public void addDependency(PersistentDependency depend) {
        if (!this._dependencies.contains(depend)) {
            this._dependencies.add(depend);
        }
    }

    public ArrayList<PersistentDependency> getDependencies() {
        return this._dependencies;
    }

    public void addCompletionField(String name) {
        this._completionFields.put(name, name);
    }

    public boolean containsCompletionField(String completionField) {
        return this._completionFields.containsKey(completionField);
    }

    public void removeAllCompletionFields() {
        this._completionFields.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startConfigure() {
        AmberBeanType amberBeanType = this;
        synchronized (amberBeanType) {
            if (this._isConfigured) {
                return false;
            }
            this._isConfigured = true;
            return true;
        }
    }

    @Override
    public void init() throws ConfigException {
        for (AmberField field : this._selfFields) {
            if (!this.getPersistenceUnit().isJPA() || !(field instanceof ManyToOneField)) continue;
            ((ManyToOneField)field).init((EntityType)this);
        }
    }

    @Override
    public String generateCastFromObject(String value) {
        return "((" + this.getInstanceClassName() + ") " + value + ")";
    }

    public void generateLoadSelect(StringBuilder sb, AmberTable table, String id, int loadGroup) {
        for (AmberField field : this.getFields()) {
            String propSelect;
            if (field.getLoadGroupIndex() != loadGroup || (propSelect = field.generateLoadSelect(table, id)) == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(propSelect);
        }
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index, int loadGroupIndex) throws IOException {
        if (this.getDiscriminator() != null) {
            boolean isAbstractParent;
            EntityType parent = null;
            if (this instanceof EntityType) {
                parent = ((EntityType)this).getParentType();
            }
            boolean bl = isAbstractParent = this.getPersistenceUnit().isJPA() && (parent == null || Modifier.isAbstract(parent.getBeanClass().getModifiers()));
            if (loadGroupIndex == 0 || isAbstractParent) {
                ++index;
            }
        }
        for (AmberField field : this.getFields()) {
            if (field.getLoadGroupIndex() != loadGroupIndex) continue;
            index = field.generateLoad(out, rs, indexVar, index);
        }
        return index;
    }

    public abstract String generateLoadSelect(AmberTable var1, String var2);

    public String generateLoadSelect(AmberTable table, String id, int loadGroup) {
        StringBuilder sb = new StringBuilder();
        this.generateLoadSelect(sb, table, id, loadGroup);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void generatePrePersist(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePrePersist(out);
        }
    }

    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateInvalidateForeign(out);
        }
    }

    public void generateExpire(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateExpire(out);
        }
    }

    public Method getGetter(String name) {
        return AmberBeanType.getGetter(this._tBeanClass, name);
    }

    public static Method getGetter(Class cl, String name) {
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 0) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperclass()) != null) {
            return AmberBeanType.getGetter(cl, name);
        }
        return null;
    }

    public static Field getField(Class cl, String name) {
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        if ((cl = cl.getSuperclass()) != null) {
            return AmberBeanType.getField(cl, name);
        }
        return null;
    }

    public static Method getSetter(Class cl, String name) {
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 1) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperclass()) != null) {
            return AmberBeanType.getSetter(cl, name);
        }
        return null;
    }

    public long getCreateLoadMask(int group) {
        long mask = 0L;
        for (AmberField field : this.getFields()) {
            mask |= field.getCreateLoadMask(group);
        }
        return mask;
    }
}

