/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.actor.RemoteActorSender;
import com.caucho.boot.AbstractRemoteCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.vfs.Path;

public abstract class AbstractRepositoryCommand
extends AbstractRemoteCommand {
    @Override
    protected void initBootOptions() {
        this.addValueOption("name", "name", "name of the deployment context");
        super.initBootOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try (WebAppDeployClient deployClient = null;){
            deployClient = this.getDeployClient(args, client);
            int n = this.doCommand(args, client, deployClient);
            return n;
        }
    }

    protected abstract int doCommand(WatchdogArgs var1, WatchdogClient var2, WebAppDeployClient var3);

    protected WebAppDeployClient getDeployClient(WatchdogArgs args, WatchdogClient client) {
        RemoteActorSender sender = this.createBamClient(args, client);
        return new WebAppDeployClient(sender.getUrl(), sender);
    }

    String getName(WatchdogArgs args, Path path) {
        return AbstractRepositoryCommand.getWebAppName(args, path);
    }

    static String getWebAppName(WatchdogArgs args, Path path) {
        String name = args.getArg("-name");
        String webapp = args.getArg("-web-app");
        if (webapp != null) {
            name = webapp;
        }
        if (name == null && path != null) {
            String tail = path.getTail();
            int p = tail.lastIndexOf(46);
            name = p > 0 ? tail.substring(0, p) : tail;
        }
        if (name == null && args.getDefaultArg() != null) {
            name = args.getDefaultArg();
        }
        if (name == null || name.equals("/")) {
            name = "ROOT";
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }
}

