/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;

public class LicenseAddCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(LicenseAddCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("license", "license file", "path to license file to add (required)");
        this.addSpacerOption();
        this.addValueOption("to", "filename", "file name license will be written to (defaults to name of license file)");
        this.addFlagOption("overwrite", "overwrite existing license file if exists");
        this.addFlagOption("restart", "restart Resin after license is added");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "adds a Resin-Professional license to an installation";
    }

    @Override
    public boolean isProOnly() {
        return false;
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        ArrayList<String> licenses = new ArrayList<String>();
        licenses.addAll(args.getTailArgs());
        String licensePath = args.getArg("-license");
        if (licensePath != null) {
            licenses.add(licensePath);
        }
        if (licenses.size() == 0) {
            System.err.println(L.l("-license is required"));
            this.usage(false);
            return 1;
        }
        int value = 1;
        for (int i = 0; i < licenses.size(); ++i) {
            boolean isLast = i + 1 == licenses.size();
            String license = (String)licenses.get(i);
            value = this.addLicense(args, client, managerClient, license, isLast);
        }
        return value;
    }

    private int addLicense(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient, String licensePath, boolean isLast) {
        String fileName = args.getArg("-to");
        boolean overwrite = args.hasOption("-overwrite");
        boolean restart = args.hasOption("-restart") && isLast;
        Path path = Vfs.lookup(licensePath);
        if (fileName == null) {
            fileName = path.getTail();
        }
        if (!fileName.endsWith(".license")) {
            System.err.println(L.l("license '{0}' must end with .license", (Object)fileName));
            return 1;
        }
        String licenseContent = null;
        ReadStream is = null;
        try {
            is = path.openRead();
        }
        catch (IOException e) {
            throw new ConfigException(L.l("Could not open {0} for read: {1}", (Object)path, (Object)e.toString()), e);
        }
        CharBuffer cb = new CharBuffer();
        try {
            int ch;
            while ((ch = is.read()) >= 0) {
                cb.append((char)ch);
            }
            licenseContent = cb.toString();
        }
        catch (IOException e) {
            throw new ConfigException(L.l("Failed to read {0}: {1}", (Object)path, (Object)e.toString()), e);
        }
        finally {
            if (cb != null) {
                cb.close();
            }
            if (is != null) {
                is.close();
            }
        }
        if (licenseContent == null || licenseContent.isEmpty()) {
            throw new ConfigException(L.l("Failed to read {0}: empty", (Object)path));
        }
        StringQueryReply result = managerClient.addLicense(licenseContent, fileName, overwrite, restart);
        System.out.println(result.getValue());
        return 0;
    }
}

