/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.PidQuery;
import com.caucho.boot.WatchdogChild;
import com.caucho.boot.WatchdogChildProcess;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.thread.ThreadPool;
import com.caucho.lifecycle.Lifecycle;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchdogChildTask
implements Runnable {
    private static final Logger log = Logger.getLogger(WatchdogChildTask.class.getName());
    private static final long BAD_CONFIG_DELAY_TIME = 30000L;
    private final ResinSystem _system;
    private final WatchdogChild _watchdog;
    private final Lifecycle _lifecycle = new Lifecycle();
    private WatchdogChildProcess _process;
    private boolean _isRestart;
    private String _restartMessage;
    private ExitCode _previousExitCode;
    private String _shutdownMessage;

    WatchdogChildTask(ResinSystem system, WatchdogChild watchdog) {
        this._system = system;
        this._watchdog = watchdog;
        if (watchdog == null) {
            throw new NullPointerException();
        }
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    String getState() {
        return this._lifecycle.getStateName();
    }

    int getPid() {
        WatchdogChildProcess process = this._process;
        if (process == null) {
            return 0;
        }
        int pid = process.getPid();
        if (pid > 0) {
            return pid;
        }
        PidQuery pidQuery = new PidQuery();
        try {
            PidQuery result = (PidQuery)process.queryGet(pidQuery);
            if (result != null) {
                return result.getPid();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return 0;
    }

    long getUptime() {
        WatchdogChildProcess process = this._process;
        if (process == null) {
            return 0L;
        }
        return process.getUptime();
    }

    boolean isRestart() {
        return this._isRestart;
    }

    String getRestartMessage() {
        return this._restartMessage;
    }

    ExitCode getPreviousExitCode() {
        return this._previousExitCode;
    }

    String getShutdownMessage() {
        return this._shutdownMessage;
    }

    void setShutdownMessage(String msg) {
        this._shutdownMessage = msg;
    }

    Serializable queryGet(Serializable payload) {
        WatchdogChildProcess process = this._process;
        if (process != null) {
            return process.queryGet(payload);
        }
        return null;
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._isRestart = false;
        this._restartMessage = "user start from watchdog";
        ThreadPool.getCurrent().schedule(this);
    }

    public void stop() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        WatchdogChildProcess process = this._process;
        this._process = null;
        if (process != null) {
            process.stop();
            process.waitForExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread thread = Thread.currentThread();
            thread.setName("watchdog-" + this._watchdog.getId());
            int i = 0;
            long retry = Long.MAX_VALUE;
            while (this._lifecycle.isActive() && (long)i++ < retry) {
                WatchdogChildProcess process;
                String id = String.valueOf(this._watchdog.getId());
                this._watchdog.notifyTaskStarted();
                log.info(this._watchdog + " starting");
                this._process = process = new WatchdogChildProcess(id, this._system, this._watchdog, this);
                String lastShutdownMessage = this._shutdownMessage;
                try {
                    this._process.run();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                finally {
                    this._process = null;
                    if (process != null) {
                        process.kill();
                    }
                }
                this._isRestart = true;
                this._restartMessage = process.getExitMessage();
                if (this._lifecycle.isActive() && process.getStatus() == ExitCode.BAD_CONFIG.ordinal()) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (lastShutdownMessage != this._shutdownMessage) continue;
                this._shutdownMessage = null;
            }
            log.info(this._watchdog + " stopped");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._lifecycle.toDestroy();
            this._watchdog.completeTask(this);
        }
    }

    void kill() {
        this._lifecycle.toDestroy();
        WatchdogChildProcess process = this._process;
        this._process = null;
        if (process != null) {
            process.kill();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._watchdog + "]";
    }
}

