/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class JConstructorWrapper
extends JMethod {
    private JClassLoader _loader;
    private Constructor _method;

    public JConstructorWrapper(Constructor method, JClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this._method = method;
        this._loader = loader;
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this._method.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this._method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this._method.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this._method.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this._method.getModifiers());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._method.getModifiers());
    }

    @Override
    public JClass getDeclaringClass() {
        return this._loader.forName(this._method.getDeclaringClass().getName());
    }

    @Override
    public JClass getReturnType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JType getGenericReturnType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JClass[] getParameterTypes() {
        Class<?>[] types = this._method.getParameterTypes();
        JClass[] jTypes = new JClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            jTypes[i] = this._loader.forName(types[i].getName());
        }
        return jTypes;
    }

    @Override
    public JClass[] getExceptionTypes() {
        Class<?>[] types = this._method.getExceptionTypes();
        JClass[] jTypes = new JClass[types.length];
        for (int i = 0; i < types.length; ++i) {
            jTypes[i] = this._loader.forName(types[i].getName());
        }
        return jTypes;
    }

    @Override
    public JAnnotation[] getDeclaredAnnotations() {
        return new JAnnotation[0];
    }
}

