/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.bam;

import com.caucho.bam.QueueFullException;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class BamQueueFullHandler {
    private static final Logger log = Logger.getLogger(BamQueueFullHandler.class.getName());
    private static final L10N L = new L10N(BamQueueFullHandler.class);
    public static final BamQueueFullHandler DEFAULT = new BamQueueFullHandler(null);
    private final ResinSystem _resinSystem;
    private final long _duplicateTimeout = 60000L;
    private final long _fatalTimeout = 180000L;
    private final AtomicLong _lastExceptionTime = new AtomicLong();
    private final AtomicLong _lastWarningTime = new AtomicLong();
    private final AtomicLong _firstSequenceTime = new AtomicLong();
    private final AtomicInteger _repeatCount = new AtomicInteger();

    BamQueueFullHandler(ResinSystem resinSystem) {
        this._resinSystem = resinSystem;
    }

    public void onQueueFull(Mailbox service, int queueSize, long timeout, TimeUnit unit, Object message) {
        long lastExceptionTime = this._lastExceptionTime.get();
        long firstSequenceTime = this._firstSequenceTime.get();
        int repeatCount = this._repeatCount.get();
        long now = CurrentTime.getCurrentTime();
        this._lastExceptionTime.set(now);
        if (now - lastExceptionTime < 60000L) {
            this._repeatCount.incrementAndGet();
        } else {
            this._repeatCount.set(0);
            this._firstSequenceTime.set(now);
            firstSequenceTime = now;
        }
        this._lastExceptionTime.set(now);
        String msg = L.l("Queue full in service {0}: queue-size={1}, timeout={2}ms, full-duration={3}ms, message={4}", (Object)service, (Object)queueSize, (Object)unit.toMillis(timeout), (Object)(now - firstSequenceTime), message);
        if (repeatCount > 0) {
            msg = msg + L.l(" repeats {0} times.", repeatCount);
        }
        if (180000L < now - firstSequenceTime) {
            ShutdownSystem.shutdownActive(ExitCode.NETWORK, msg);
            log.warning(msg);
        } else if (now - this._lastWarningTime.get() > 5000L) {
            log.warning(msg);
            this._lastWarningTime.set(now);
        }
        QueueFullException exn = new QueueFullException(msg);
        throw exn;
    }
}

