/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectFactory;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.SecurityGenerator;
import com.caucho.inject.Module;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.enterprise.inject.spi.AnnotatedMethod;

@Module
public class SecurityFactory<X>
extends AbstractAspectFactory<X> {
    private final RunAs _classRunAs;
    private final RolesAllowed _classRolesAllowed;
    private final PermitAll _classPermitAll;
    private final DenyAll _classDenyAll;

    public SecurityFactory(AspectBeanFactory<X> beanFactory, AspectFactory<X> next) {
        super(beanFactory, next);
        this._classRunAs = (RunAs)beanFactory.getBeanType().getAnnotation(RunAs.class);
        this._classRolesAllowed = (RolesAllowed)beanFactory.getBeanType().getAnnotation(RolesAllowed.class);
        this._classPermitAll = (PermitAll)beanFactory.getBeanType().getAnnotation(PermitAll.class);
        this._classDenyAll = (DenyAll)beanFactory.getBeanType().getAnnotation(DenyAll.class);
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method, boolean isEnhanced) {
        DenyAll denyAll;
        PermitAll permitAll;
        RolesAllowed rolesAllowed;
        RunAs runAs = (RunAs)method.getAnnotation(RunAs.class);
        if (runAs == null) {
            runAs = this._classRunAs;
        }
        String runAsName = null;
        if (runAs != null) {
            runAsName = runAs.value();
        }
        if ((rolesAllowed = (RolesAllowed)method.getAnnotation(RolesAllowed.class)) == null) {
            rolesAllowed = this._classRolesAllowed;
        }
        String[] roleNames = null;
        if (rolesAllowed != null) {
            roleNames = rolesAllowed.value();
        }
        if ((permitAll = (PermitAll)method.getAnnotation(PermitAll.class)) != null || this._classPermitAll != null) {
            roleNames = null;
        }
        if ((denyAll = (DenyAll)method.getAnnotation(DenyAll.class)) != null || this._classDenyAll != null) {
            roleNames = new String[]{};
        }
        if (roleNames != null || runAs != null) {
            AspectGenerator<? super X> next = super.create(method, true);
            return new SecurityGenerator<X>(this, method, next, roleNames, runAsName);
        }
        return super.create(method, isEnhanced);
    }
}

