/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.Configured;
import com.caucho.config.bytecode.ScopeAdapter;
import com.caucho.config.event.ObserverMethodImpl;
import com.caucho.config.inject.AbstractIntrospectedBean;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.config.inject.ManagedProducesBuilder;
import com.caucho.config.inject.PassivationSetter;
import com.caucho.config.inject.ScheduleBean;
import com.caucho.config.inject.ScopeAdapterBean;
import com.caucho.config.timer.ScheduleIntrospector;
import com.caucho.config.timer.TimeoutCaller;
import com.caucho.config.timer.TimerTask;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.ejb.Timer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Singleton;

@Module
public class ManagedBeanImpl<X>
extends AbstractIntrospectedBean<X>
implements ScopeAdapterBean<X>,
ScheduleBean {
    private static final L10N L = new L10N(ManagedBeanImpl.class);
    private AnnotatedType<X> _annotatedType;
    private InjectionTarget<X> _injectionTarget;
    private HashSet<ObserverMethodImpl<X, ?>> _observerMethods = new LinkedHashSet();
    private boolean _isNormalScope;
    private Object _scopeAdapter;

    public ManagedBeanImpl(InjectManager injectManager, AnnotatedType<X> beanType, boolean isSessionBean) {
        super(injectManager, beanType.getBaseType(), (Annotated)beanType);
        this._annotatedType = beanType;
        InjectionTargetBuilder<X> target = new InjectionTargetBuilder<X>(injectManager, beanType, this);
        if (isSessionBean) {
            target.setGenerateInterception(false);
        }
        this._injectionTarget = target;
    }

    public ManagedBeanImpl(InjectManager webBeans, AnnotatedType<X> beanType, InjectionTarget<X> injectionTarget) {
        this(webBeans, beanType, false);
        this._injectionTarget = injectionTarget;
    }

    @Override
    public AnnotatedType<X> getAnnotatedType() {
        return this._annotatedType;
    }

    @Override
    public InjectionTarget<X> getInjectionTarget() {
        return this._injectionTarget;
    }

    public void setInjectionTarget(InjectionTarget<X> target) {
        this._injectionTarget = target;
    }

    @Override
    protected boolean isNormalScope() {
        return this._isNormalScope;
    }

    @Override
    public X create(CreationalContext<X> context) {
        Object instance = this._injectionTarget.produce(context);
        if (context != null) {
            context.push(instance);
        }
        this._injectionTarget.inject(instance, context);
        this._injectionTarget.postConstruct(instance);
        return (X)instance;
    }

    public X createDependent(CreationalContext<X> env) {
        Object instance = this._injectionTarget.produce(env);
        if (env != null) {
            env.push(instance);
        }
        this._injectionTarget.inject(instance, env);
        this._injectionTarget.postConstruct(instance);
        return (X)instance;
    }

    @Override
    public X getScopeAdapter(Bean<?> topBean, CreationalContextImpl<X> cxt) {
        if (this.isNormalScope()) {
            Object value = this._scopeAdapter;
            if (value == null) {
                ScopeAdapter scopeAdapter = ScopeAdapter.create(this.getJavaClass());
                value = this._scopeAdapter = scopeAdapter.wrap(this.getBeanManager().createNormalInstanceFactory(topBean));
            }
            return (X)value;
        }
        return null;
    }

    protected boolean isProxiedScope() {
        NormalScope scopeType = this.getScope().getAnnotation(NormalScope.class);
        return scopeType != null && !this.getScope().equals(ApplicationScoped.class);
    }

    public Object getScopeAdapter() {
        Object value = this._scopeAdapter;
        if (value == null) {
            ScopeAdapter scopeAdapter = ScopeAdapter.create(this.getTargetClass());
            value = this._scopeAdapter = scopeAdapter.wrap(this.getBeanManager().createNormalInstanceFactory(this));
        }
        return value;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this._injectionTarget.getInjectionPoints();
    }

    public boolean validate() {
        if (this._injectionTarget instanceof InjectionTargetBuilder) {
            ((InjectionTargetBuilder)this._injectionTarget).validate();
            return true;
        }
        return false;
    }

    public Set<ObserverMethodImpl<X, ?>> getObserverMethods() {
        return this._observerMethods;
    }

    @Override
    public void dispose(X instance) {
    }

    @Override
    public void destroy(X instance, CreationalContext<X> cxt) {
        this._injectionTarget.preDestroy(instance);
        if (cxt != null) {
            if (cxt instanceof CreationalContextImpl) {
                CreationalContextImpl env = (CreationalContextImpl)cxt;
                env.clearTarget();
            }
            cxt.release();
        }
    }

    @Override
    public void introspect() {
        super.introspect();
        this.introspect(this._annotatedType);
        if (this._injectionTarget instanceof PassivationSetter && this.getId() != null) {
            ((PassivationSetter)this._injectionTarget).setPassivationId(this.getId());
        }
        this.validateBean();
        this.validatePassivation();
        this._isNormalScope = this.getScope().isAnnotationPresent(NormalScope.class);
    }

    private void validateBean() {
        Class javaClass = this._annotatedType.getJavaClass();
        Class<Annotation> scopeType = this.getScope();
        if (!(javaClass.getTypeParameters().length == 0 || this._annotatedType.isAnnotationPresent(Configured.class) || Singleton.class.equals(scopeType) || Dependent.class.equals(scopeType))) {
            throw new ConfigException(L.l("'{0}' is an invalid bean because it has a generic type and a non-dependent scope.", (Object)javaClass.getName()));
        }
    }

    private void validatePassivation() {
        Class<Annotation> scopeType = this.getScope();
        if (scopeType == null) {
            return;
        }
        if (!this.getBeanManager().isNormalScope(scopeType)) {
            return;
        }
        Class cl = this._annotatedType.getJavaClass();
        if (Modifier.isFinal(cl.getModifiers())) {
            throw new ConfigException(L.l("'{0}' is an invalid @{1} bean because it is final.", (Object)cl.getName(), (Object)scopeType.getName()));
        }
    }

    protected void introspect(AnnotatedType<X> beanType) {
    }

    public void introspectProduces() {
        ManagedProducesBuilder builder = new ManagedProducesBuilder(this.getBeanManager());
        builder.introspectProduces(this, this.getAnnotatedType());
    }

    @Override
    public void scheduleTimers(Object value) {
        ScheduleIntrospector introspector = new ScheduleIntrospector();
        BeanTimeoutCaller timeoutCaller = new BeanTimeoutCaller(value);
        ArrayList<TimerTask> taskList = introspector.introspect(timeoutCaller, this._annotatedType);
        if (taskList != null) {
            for (TimerTask task : taskList) {
                task.start();
            }
        }
    }

    static class BeanTimeoutCaller
    implements TimeoutCaller {
        private Object _bean;

        BeanTimeoutCaller(Object bean) {
            this._bean = bean;
        }

        @Override
        public void timeout(Method method) throws InvocationTargetException, IllegalAccessException {
            method.invoke(this._bean, new Object[0]);
        }

        @Override
        public void timeout(Method method, Timer timer) throws InvocationTargetException, IllegalAccessException {
        }
    }
}

