/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.inject.AnyLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.naming.NamingException;

public class JavaeeResourceGenerator
extends ValueGenerator {
    private static final Logger log = Logger.getLogger(JavaeeResourceGenerator.class.getName());
    private static final L10N L = new L10N(JavaeeResourceGenerator.class);
    private static HashMap<Class<?>, Class<?>> _primitiveTypeMap = new HashMap();
    private final String _location;
    private final Class<?> _fieldType;
    private final Class<?> _type;
    private final String _jndiName;
    private final String _mappedName;
    private final String _beanName;
    private InjectManager _beanManager = InjectManager.create();
    private Bean<?> _bean;

    JavaeeResourceGenerator(String location, Class<?> fieldType, Class<?> type, String jndiName, String mappedName, String beanName) {
        if (!fieldType.isAssignableFrom(type)) {
            type = fieldType;
        }
        if (type.isPrimitive()) {
            type = _primitiveTypeMap.get(type);
        }
        this._location = location;
        this._fieldType = fieldType;
        this._type = type;
        this._jndiName = jndiName;
        this._mappedName = mappedName;
        this._beanName = beanName;
    }

    public Class getType() {
        return this._type;
    }

    @Override
    public Object create() {
        Object value = Jndi.lookup(this._jndiName);
        if (value != null) {
            return value;
        }
        Bean bean = this._bean;
        if (this._bean == null) {
            bean = this.bind();
        }
        CreationalContext cxt = this._beanManager.createCreationalContext(bean);
        value = this._beanManager.getReference(bean, bean.getBeanClass(), cxt);
        return value;
    }

    private synchronized Bean bind() {
        Object bean = null;
        this._bean = this.bind(this._location, this._type, this._mappedName);
        if (this._bean != null) {
            JavaeeResourceGenerator.bindJndi(this._location, this._jndiName, this._bean);
            return this._bean;
        }
        if (this._bean == null && this._beanName != null && !"".equals(this._beanName)) {
            this._bean = this.bind(this._location, this._type, this._beanName);
            if (this._bean != null) {
                JavaeeResourceGenerator.bindJndi(this._location, this._jndiName, this._bean);
                return this._bean;
            }
        }
        if (this._bean == null && this._jndiName != null && !"".equals(this._jndiName)) {
            this._bean = this.bind(this._location, this._type, this._jndiName);
            if (this._bean != null) {
                JavaeeResourceGenerator.bindJndi(this._location, this._jndiName, this._bean);
                return this._bean;
            }
        }
        if (this._bean == null) {
            this._bean = this.bind(this._location, this._type);
        }
        if (this._bean != null) {
            JavaeeResourceGenerator.bindJndi(this._location, this._jndiName, this._bean);
            return this._bean;
        }
        throw new ConfigException(this._location + L.l("{0} with mappedName={1}, beanName={2}, and jndiName={3} does not match anything", (Object)this._type.getName(), (Object)this._mappedName, (Object)this._beanName, (Object)this._jndiName));
    }

    public Bean bind(String location, Class type) {
        return this.bind(location, type, null);
    }

    public Bean bind(String location, Class type, String name) {
        InjectManager webBeans = this._beanManager;
        Set<Bean<?>> beans = null;
        if (name != null) {
            beans = webBeans.getBeans((Type)type, new Annotation[]{Names.create(name)});
        }
        if (beans != null && beans.size() != 0) {
            return webBeans.resolve(beans);
        }
        beans = webBeans.getBeans((Type)type, new Annotation[]{AnyLiteral.ANY});
        if (beans == null || beans.size() == 0) {
            return null;
        }
        for (Bean<?> bean : beans) {
            if (name != null && !name.equals(bean.getName())) continue;
            return bean;
        }
        return null;
    }

    private static void bindJndi(String location, String name, Object value) {
        try {
            if (!"".equals(name)) {
                Jndi.bindDeepShort(name, value);
            }
        }
        catch (NamingException e) {
            throw new ConfigException(location + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._type.getName());
        if (this._mappedName != null) {
            sb.append(", mappedName=");
            sb.append(this._mappedName);
        }
        if (this._jndiName != null) {
            sb.append(", jndiName=");
            sb.append(this._jndiName);
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        _primitiveTypeMap.put(Boolean.TYPE, Boolean.class);
        _primitiveTypeMap.put(Byte.TYPE, Byte.class);
        _primitiveTypeMap.put(Character.TYPE, Character.class);
        _primitiveTypeMap.put(Short.TYPE, Short.class);
        _primitiveTypeMap.put(Integer.TYPE, Integer.class);
        _primitiveTypeMap.put(Long.TYPE, Long.class);
        _primitiveTypeMap.put(Float.TYPE, Float.class);
        _primitiveTypeMap.put(Double.TYPE, Double.class);
    }
}

